/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.item.custom;

import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ThrownSacItem
extends Item {
    private final BiFunction<Level, Player, ? extends ThrowableItemProjectile> projectileFactory;
    private final boolean requireSneakToThrow;

    public ThrownSacItem(Item.Properties props, BiFunction<Level, Player, ? extends ThrowableItemProjectile> projectileFactory) {
        this(props, projectileFactory, true);
    }

    public ThrownSacItem(Item.Properties props, BiFunction<Level, Player, ? extends ThrowableItemProjectile> projectileFactory, boolean requireSneakToThrow) {
        super(props);
        this.projectileFactory = projectileFactory;
        this.requireSneakToThrow = requireSneakToThrow;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.hexalia.throwable").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        boolean shouldThrow;
        ItemStack stack = player.getItemInHand(hand);
        boolean bl = shouldThrow = !this.requireSneakToThrow || player.isShiftKeyDown();
        if (shouldThrow) {
            if (!level.isClientSide) {
                ThrowableItemProjectile proj = this.projectileFactory.apply(level, player);
                proj.setItem(stack.copyWithCount(1));
                proj.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.5f, 1.0f);
                level.addFreshEntity((Entity)proj);
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SPLASH_POTION_THROW, SoundSource.PLAYERS, 0.5f, 0.8f + level.getRandom().nextFloat() * 0.4f);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
        }
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
    }
}

