/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.astralya.hexalia.recipe.ModRecipes;
import net.astralya.hexalia.recipe.MutationRecipeInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record MutationRecipe(Ingredient inputItem, ItemStack output) implements Recipe<MutationRecipeInput>
{
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.inputItem);
        return list;
    }

    public boolean matches(MutationRecipeInput input, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        return this.inputItem.test(input.getItem(0));
    }

    public ItemStack assemble(MutationRecipeInput input, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int w, int h) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.MUTATION_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.MUTATION_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<MutationRecipe> {
        public static final MapCodec<MutationRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(MutationRecipe::inputItem), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("output").xmap(ItemStack::new, ItemStack::getItem).forGetter(MutationRecipe::output)).apply((Applicative)inst, MutationRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, MutationRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, MutationRecipe::inputItem, (StreamCodec)ItemStack.STREAM_CODEC, MutationRecipe::output, MutationRecipe::new);

        public MapCodec<MutationRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MutationRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

