/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.screen.custom;

import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.block.entity.custom.SmallCauldronBlockEntity;
import net.astralya.hexalia.screen.ModMenuTypes;
import net.astralya.hexalia.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class SmallCauldronMenu
extends AbstractContainerMenu {
    public final SmallCauldronBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 5;

    public SmallCauldronMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(2));
    }

    public SmallCauldronMenu(int containerId, Inventory inv, BlockEntity blockEntity, ContainerData data) {
        super((MenuType)ModMenuTypes.SMALL_CAULDRON_MENU.get(), containerId);
        this.blockEntity = (SmallCauldronBlockEntity)blockEntity;
        this.level = inv.player.level();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.inventory, 0, 30, 27){

            public boolean mayPlace(ItemStack stack) {
                return !SmallCauldronMenu.this.isBottle(stack) && super.mayPlace(stack);
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.inventory, 1, 48, 27){

            public boolean mayPlace(ItemStack stack) {
                return !SmallCauldronMenu.this.isBottle(stack) && super.mayPlace(stack);
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.inventory, 2, 66, 27){

            public boolean mayPlace(ItemStack stack) {
                return !SmallCauldronMenu.this.isBottle(stack) && super.mayPlace(stack);
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.inventory, 3, 124, 28){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.inventory, 4, 48, 48){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(ModTags.Items.BREWS);
            }
        });
        this.addDataSlots(data);
    }

    private boolean isBottle(ItemStack stack) {
        return stack.is(ModTags.Items.BREWS);
    }

    public void removed(Player player) {
        super.removed(player);
        this.blockEntity.setLastInteractedPlayer(player);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int progressArrowSize = 26;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isHeated() {
        return this.blockEntity.isHeated();
    }

    public ItemStack quickMoveStack(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            if (sourceStack.is(ModTags.Items.BREWS) ? !this.moveItemStackTo(sourceStack, 40, 41, false) : !this.moveItemStackTo(sourceStack, 36, 39, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 41) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(Player player) {
        return SmallCauldronMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)ModBlocks.SMALL_CAULDRON.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

