/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.util;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;

public class ModTags {

    public static class Biomes {
        public static final TagKey<Biome> HAS_MANDRAKES = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hexalia", (String)"has_mandrakes"));
        public static final TagKey<Biome> HAS_DREAMSHROOMS = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hexalia", (String)"has_dreamshrooms"));
        public static final TagKey<Biome> HAS_SIREN_KELP = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hexalia", (String)"has_siren_kelp"));
        public static final TagKey<Biome> HAS_GHOST_FERNS = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hexalia", (String)"has_ghost_ferns"));
        public static final TagKey<Biome> HAS_SWAMP_VEGETATION = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hexalia", (String)"has_swamp_vegetation"));
        public static final TagKey<Biome> HAS_DECORATIVE_FLOWERS = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hexalia", (String)"has_decorative_flowers"));
    }

    public static class Compat {
        public static final String SERENE_SEASONS = "sereneseasons";
        public static final TagKey<Block> SERENE_SEASONS_AUTUMN_CROPS_BLOCK = Compat.externalBlockTag("sereneseasons", "autumn_crops");
        public static final TagKey<Block> SERENE_SEASONS_SPRING_CROPS_BLOCK = Compat.externalBlockTag("sereneseasons", "spring_crops");
        public static final TagKey<Block> SERENE_SEASONS_SUMMER_CROPS_BLOCK = Compat.externalBlockTag("sereneseasons", "summer_crops");
        public static final TagKey<Block> SERENE_SEASONS_WINTER_CROPS_BLOCK = Compat.externalBlockTag("sereneseasons", "winter_crops");
        public static final TagKey<Block> SERENE_SEASONS_UNBREAKABLE_FERTILE_CROPS = Compat.externalBlockTag("sereneseasons", "unbreakable_infertile_crops");
        public static final TagKey<Item> SERENE_SEASONS_AUTUMN_CROPS = Compat.externalItemTag("sereneseasons", "autumn_crops");
        public static final TagKey<Item> SERENE_SEASONS_SPRING_CROPS = Compat.externalItemTag("sereneseasons", "spring_crops");
        public static final TagKey<Item> SERENE_SEASONS_SUMMER_CROPS = Compat.externalItemTag("sereneseasons", "summer_crops");
        public static final TagKey<Item> SERENE_SEASONS_WINTER_CROPS = Compat.externalItemTag("sereneseasons", "winter_crops");

        private static TagKey<Item> externalItemTag(String modId, String path) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)path));
        }

        private static TagKey<Block> externalBlockTag(String modId, String path) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)path));
        }
    }

    public static class Blocks {
        public static final TagKey<Block> HEATING_BLOCKS = Blocks.createBlockTag("heating_block");
        public static final TagKey<Block> ATTRACTS_MOTH = Blocks.createBlockTag("attracts_moth");
        public static final TagKey<Block> COTTONWOOD_LOGS = Blocks.createBlockTag("cottonwood_logs");
        public static final TagKey<Block> WILLOW_LOGS = Blocks.createBlockTag("willow_logs");
        public static final TagKey<Block> COCOON_LOGS = Blocks.createBlockTag("cocoon_logs");
        public static final TagKey<Block> SALT_BLOCKS = Blocks.createCommonBlockTag("salt_blocks");

        private static TagKey<Block> createBlockTag(String name) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hexalia", (String)name));
        }

        private static TagKey<Block> createCommonBlockTag(String name) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }
    }

    public static class Items {
        public static final TagKey<Item> HERBS = Items.createItemTag("herbs");
        public static final TagKey<Item> CRUSHED_HERBS = Items.createItemTag("crushed_herbs");
        public static final TagKey<Item> BREWS = Items.createItemTag("brews");
        public static final TagKey<Item> COTTONWOOD_LOGS = Items.createItemTag("cottonwood_logs");
        public static final TagKey<Item> WILLOW_LOGS = Items.createItemTag("willow_logs");
        public static final TagKey<Item> OFFHAND_EQUIPMENT = Items.createItemTag("offhand_equipment");
        public static final TagKey<Item> TULIPS = Items.createItemTag("tulips");
        public static final TagKey<Item> FOODS = Items.createCommonItemTag("foods");
        public static final TagKey<Item> FOODS_BREAD = Items.createCommonItemTag("foods/bread");
        public static final TagKey<Item> CROPS = Items.createCommonItemTag("crops");
        public static final TagKey<Item> FOODS_BERRY = Items.createCommonItemTag("foods/berry");
        public static final TagKey<Item> FOODS_COOKED_MEAT = Items.createCommonItemTag("foods/cooked_meat");
        public static final TagKey<Item> FOODS_SOUP = Items.createCommonItemTag("foods/soup");
        public static final TagKey<Item> FOODS_PIE = Items.createCommonItemTag("foods/pie");
        public static final TagKey<Item> FOODS_FOOD_POISONING = Items.createCommonItemTag("foods/food_poisoning");
        public static final TagKey<Item> FOODS_VEGETABLE = Items.createCommonItemTag("foods/vegetable");
        public static final TagKey<Item> SALT = Items.createCommonItemTag("salt");
        public static final TagKey<Item> SEEDS = Items.createCommonItemTag("seeds");
        public static final TagKey<Item> MUSHROOMS = Items.createCommonItemTag("mushrooms");
        public static final TagKey<Item> SALT_BLOCKS = Items.createCommonItemTag("salt_blocks");

        private static TagKey<Item> createItemTag(String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hexalia", (String)name));
        }

        private static TagKey<Item> createCommonItemTag(String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }
    }
}

