/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.worldgen;

import java.util.Optional;
import net.astralya.hexalia.util.ModTags;
import net.astralya.hexalia.worldgen.ModPlacedFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ModBiomeModifier {
    public static final ResourceKey<BiomeModifier> ADD_SPIRIT_BLOOM = ModBiomeModifier.registerKey("add_spirit_bloom");
    public static final ResourceKey<BiomeModifier> ADD_DREAMSHROOM = ModBiomeModifier.registerKey("add_dreamshroom");
    public static final ResourceKey<BiomeModifier> ADD_SIREN_KELP = ModBiomeModifier.registerKey("add_siren_kelp");
    public static final ResourceKey<BiomeModifier> ADD_GHOST_FERN = ModBiomeModifier.registerKey("add_ghost_fern");
    public static final ResourceKey<BiomeModifier> ADD_CELESTIAL_BLOOM = ModBiomeModifier.registerKey("add_celestial_bloom");
    public static final ResourceKey<BiomeModifier> ADD_LOTUS_FLOWER = ModBiomeModifier.registerKey("add_lotus_flower");
    public static final ResourceKey<BiomeModifier> ADD_WITCHWEED = ModBiomeModifier.registerKey("add_witchweed");
    public static final ResourceKey<BiomeModifier> ADD_PALE_MUSHROOM = ModBiomeModifier.registerKey("add_pale_mushroom");
    public static final ResourceKey<BiomeModifier> ADD_NIGHTSHADE = ModBiomeModifier.registerKey("add_nightshade");
    public static final ResourceKey<BiomeModifier> ADD_CHILLBERRY = ModBiomeModifier.registerKey("add_chillberry");
    public static final ResourceKey<BiomeModifier> ADD_WILD_SUNFIRE_TOMATO = ModBiomeModifier.registerKey("add_wild_sunfire_tomato");
    public static final ResourceKey<BiomeModifier> ADD_WILD_MANDRAKE = ModBiomeModifier.registerKey("add_wild_mandrake");
    public static final ResourceKey<BiomeModifier> ADD_DARK_OAK_COCOON = ModBiomeModifier.registerKey("add_dark_oak_cocoon");
    public static final ResourceKey<BiomeModifier> ADD_WILLOW = ModBiomeModifier.registerKey("add_willow");
    public static final ResourceKey<BiomeModifier> ADD_COTTONWOOD = ModBiomeModifier.registerKey("add_cottonwood");
    public static final ResourceKey<BiomeModifier> ADD_BEGONIA = ModBiomeModifier.registerKey("add_begonia");
    public static final ResourceKey<BiomeModifier> ADD_LAVENDER = ModBiomeModifier.registerKey("add_lavender");
    public static final ResourceKey<BiomeModifier> ADD_DAHLIA = ModBiomeModifier.registerKey("add_dahlia");

    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter biomes = context.lookup(Registries.BIOME);
        Optional taigaBiome = biomes.get(Biomes.TAIGA);
        Optional flowerForest = biomes.get(Biomes.FLOWER_FOREST);
        Optional savannaBiome = biomes.get(Biomes.SAVANNA);
        Optional darkForestBiome = biomes.get(Biomes.DARK_FOREST);
        Optional meadowBiome = biomes.get(Biomes.MEADOW);
        Optional swampBiome = biomes.get(Biomes.SWAMP);
        Optional mangroveSwampBiome = biomes.get(Biomes.MANGROVE_SWAMP);
        Optional mushroomFieldsBiome = biomes.get(Biomes.MUSHROOM_FIELDS);
        context.register(ADD_SPIRIT_BLOOM, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(ModTags.Biomes.HAS_SWAMP_VEGETATION), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.SPIRIT_BLOOM_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_DREAMSHROOM, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(ModTags.Biomes.HAS_DREAMSHROOMS), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.DREAMSHROOM_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_SIREN_KELP, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(ModTags.Biomes.HAS_SIREN_KELP), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.SIREN_KELP_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_CHILLBERRY, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{(Holder)taigaBiome.get()}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.CHILLBERRY_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_WILD_SUNFIRE_TOMATO, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{(Holder)savannaBiome.get()}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.WILD_SUNFIRE_TOMATO_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_WILD_MANDRAKE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(ModTags.Biomes.HAS_MANDRAKES), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.WILD_MANDRAKE_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_CELESTIAL_BLOOM, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{(Holder)meadowBiome.get()}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.CELESTIAL_BLOOM_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_GHOST_FERN, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(ModTags.Biomes.HAS_GHOST_FERNS), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.GHOST_FERN_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_LOTUS_FLOWER, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(ModTags.Biomes.HAS_SWAMP_VEGETATION), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.LOTUS_FLOWER_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_BEGONIA, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(ModTags.Biomes.HAS_DECORATIVE_FLOWERS), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.BEGONIA_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_LAVENDER, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{(Holder)taigaBiome.get()}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.LAVENDER_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_DAHLIA, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{(Holder)flowerForest.get()}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.DAHLIA_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_WITCHWEED, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{(Holder)flowerForest.get()}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.WITCHWEED_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_PALE_MUSHROOM, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{(Holder)mushroomFieldsBiome.get()}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.PALE_MUSHROOM_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_NIGHTSHADE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{(Holder)darkForestBiome.get()}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.NIGHTSHADE_BUSH_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_DARK_OAK_COCOON, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{(Holder)darkForestBiome.get()}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.DARK_OAK_COCOON_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_COTTONWOOD, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{(Holder)swampBiome.get()}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.COTTONWOOD_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_WILLOW, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{(Holder)mangroveSwampBiome.get()}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.WILLOW_PLACED)}), GenerationStep.Decoration.VEGETAL_DECORATION));
    }

    private static ResourceKey<BiomeModifier> registerKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hexalia", (String)name));
    }
}

