/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.worldgen.gen.decorator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.block.custom.CocoonBlock;
import net.astralya.hexalia.worldgen.gen.decorator.ModTreeDecorators;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class CocoonTreeDecorator
extends TreeDecorator {
    public static final MapCodec<CocoonTreeDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").forGetter(d -> Float.valueOf(d.chance))).apply((Applicative)instance, CocoonTreeDecorator::new));
    private final float chance;

    public CocoonTreeDecorator(float chance) {
        this.chance = chance;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)ModTreeDecorators.COCOON_TREE.get();
    }

    public void place(TreeDecorator.Context context) {
        RandomSource random = context.random();
        for (BlockPos pos : context.logs()) {
            Direction[] directions;
            Direction direction;
            BlockPos target;
            if (!(random.nextFloat() <= this.chance) || !context.isAir(target = pos.relative(direction = (directions = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH})[random.nextInt(directions.length)])) || !context.isAir(target.below())) continue;
            context.setBlock(target, (BlockState)((Block)ModBlocks.SILKWORM_COCOON.get()).defaultBlockState().setValue((Property)CocoonBlock.FACING, (Comparable)direction));
            break;
        }
    }
}

