/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import net.astralya.hexalia.block.custom.EnchantedPlantBlock;
import net.astralya.hexalia.block.entity.custom.AstrylisBlockEntity;
import net.astralya.hexalia.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class AstrylisBlock
extends EnchantedPlantBlock
implements EntityBlock {
    public AstrylisBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        AstrylisBlockEntity astrylis;
        BlockEntity blockEntity;
        if (level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof AstrylisBlockEntity && (astrylis = (AstrylisBlockEntity)blockEntity).isActive()) {
            float progress = astrylis.getProgress();
            int particleCount = Math.max(2, (int)(6.0f * (1.0f - progress * 0.5f)));
            for (int i = 0; i < particleCount; ++i) {
                double x = (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 0.3;
                double y = (double)pos.getY() + 0.7 + random.nextDouble() * 0.3;
                double z = (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 0.3;
                level.addParticle((ParticleOptions)ParticleTypes.EFFECT, x, y, z, 0.0, 0.01, 0.0);
            }
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemStack = player.getItemInHand(hand);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AstrylisBlockEntity) {
            AstrylisBlockEntity astrylis = (AstrylisBlockEntity)blockEntity;
            if (itemStack.isEmpty()) {
                if (!astrylis.isActive()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.hexalia.astrylis.inactive"), true);
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (itemStack.getItem() == ModItems.CELESTIAL_CRYSTAL.get() && !astrylis.isActive()) {
                astrylis.activate(level.getGameTime());
                level.playSound(null, pos, SoundEvents.AMETHYST_BLOCK_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.isCreative()) {
                    itemStack.shrink(1);
                }
                player.displayClientMessage((Component)Component.translatable((String)"message.hexalia.astrylis.activation"), true);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new AstrylisBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : (level1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof AstrylisBlockEntity) {
                AstrylisBlockEntity astrylis = (AstrylisBlockEntity)blockEntity;
                AstrylisBlockEntity.tick(level1, pos, state1, astrylis);
            }
        };
    }
}

