/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.custom.HerbBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class CelestialBloomBlock
extends HerbBlock {
    private static final double MIN_X = 5.0;
    private static final double MAX_X = 11.0;
    private static final double MIN_Z = 5.0;
    private static final double MAX_Z = 11.0;
    private static final double HEIGHT = 10.0;

    public CelestialBloomBlock(Holder<MobEffect> effect, float seconds, BlockBehaviour.Properties properties) {
        super(effect, seconds, properties);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (level.isClientSide() && ((Boolean)Configuration.CELESTIAL_BLOOM_EMITS_PARTICLES.get()).booleanValue() && random.nextFloat() < 0.2f) {
            double centerX = (double)pos.getX() + 0.5;
            double centerZ = (double)pos.getZ() + 0.5;
            double x = centerX + (random.nextDouble() - 0.5) * 6.0 / 16.0;
            double y = (double)pos.getY() + random.nextDouble() * 10.0 / 16.0;
            double z = centerZ + (random.nextDouble() - 0.5) * 6.0 / 16.0;
            if (random.nextBoolean()) {
                x = centerX + (random.nextBoolean() ? 11.5 : 4.5) / 16.0;
            } else {
                z = centerZ + (random.nextBoolean() ? 11.5 : 4.5) / 16.0;
            }
            double motionX = (random.nextDouble() - 0.5) * 0.02;
            double motionY = random.nextDouble() * 0.02;
            double motionZ = (random.nextDouble() - 0.5) * 0.02;
            level.addParticle((ParticleOptions)ParticleTypes.END_ROD, x, y, z, motionX, motionY, motionZ);
        }
    }
}

