/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import com.mojang.serialization.MapCodec;
import net.astralya.hexalia.block.entity.custom.RitualBrazierBlockEntity;
import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RitualBrazierBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty SALTED = BooleanProperty.create((String)"salted");
    protected static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), (VoxelShape[])new VoxelShape[0]);
    public static final MapCodec<RitualBrazierBlock> CODEC = RitualBrazierBlock.simpleCodec(RitualBrazierBlock::new);

    public RitualBrazierBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SALTED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)SALTED, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, SALTED});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RitualBrazierBlockEntity(pos, state);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity be;
        if (state.getBlock() != newState.getBlock() && (be = level.getBlockEntity(pos)) instanceof RitualBrazierBlockEntity) {
            RitualBrazierBlockEntity brazier = (RitualBrazierBlockEntity)be;
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)brazier.getStoredItem());
            if (((Boolean)state.getValue((Property)SALTED)).booleanValue()) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)new ItemStack((ItemLike)ModItems.SALT.get()));
            }
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (!(tileEntity instanceof RitualBrazierBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        RitualBrazierBlockEntity brazier = (RitualBrazierBlockEntity)tileEntity;
        ItemStack heldStack = player.getItemInHand(hand);
        ItemStack offhandStack = player.getOffhandItem();
        if (hand == InteractionHand.MAIN_HAND && !((Boolean)state.getValue((Property)SALTED)).booleanValue() && stack.is(ModTags.Items.SALT) && !((Boolean)state.getValue((Property)SALTED)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SALTED, (Comparable)Boolean.valueOf(true)), 3);
            if (!player.isCreative()) {
                heldStack.shrink(1);
            }
            level.playSound(null, pos, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        if (brazier.isEmpty()) {
            if (!offhandStack.isEmpty()) {
                if (hand == InteractionHand.MAIN_HAND && !offhandStack.is(ModTags.Items.OFFHAND_EQUIPMENT) && !(heldStack.getItem() instanceof BlockItem)) {
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                if (hand == InteractionHand.OFF_HAND && offhandStack.is(ModTags.Items.OFFHAND_EQUIPMENT)) {
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
            }
            if (heldStack.isEmpty()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (brazier.addItem(player.getAbilities().instabuild ? heldStack.copy() : heldStack)) {
                this.playItemSound(level, pos);
                return ItemInteractionResult.SUCCESS;
            }
        } else if (!heldStack.isEmpty() || !offhandStack.isEmpty()) {
            ItemStack focusStack;
            ItemStack itemStack = heldStack.is(ModItems.HEX_FOCUS) ? heldStack : (focusStack = offhandStack.is(ModItems.HEX_FOCUS) ? offhandStack : ItemStack.EMPTY);
            if (!focusStack.isEmpty()) {
                if (!level.isClientSide()) {
                    RitualBrazierBlockEntity.RitualResult result = brazier.tryCelestialRitual();
                    switch (result) {
                        case SUCCESS: {
                            RitualBrazierBlock.spawnPoofParticles(level, pos);
                            level.playSound(null, pos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 0.25f, 0.25f);
                            break;
                        }
                        case NO_CELESTIAL_BLOOMS: {
                            player.displayClientMessage((Component)Component.translatable((String)"message.hexalia.ritual_brazier.no_celestial_blooms"), true);
                            break;
                        }
                        case INVALID_ITEM: {
                            player.displayClientMessage((Component)Component.translatable((String)"message.hexalia.ritual_brazier.invalid_item"), true);
                        }
                    }
                }
                return ItemInteractionResult.SUCCESS;
            }
        } else if (hand == InteractionHand.MAIN_HAND) {
            if (!player.isCreative()) {
                if (!player.getInventory().add(brazier.removeItem())) {
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)brazier.removeItem());
                }
            } else {
                brazier.removeItem();
            }
            this.playItemSound(level, pos);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private static void spawnPoofParticles(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.sendParticles((ParticleOptions)ParticleTypes.POOF, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 10, 0.2, 0.2, 0.2, 0.02);
        }
    }

    private void playItemSound(Level level, BlockPos pos) {
        level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.25f, 0.25f);
    }
}

