/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import com.mojang.serialization.MapCodec;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.TriState;

public class SaltsproutBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<SaltsproutBlock> CODEC = SaltsproutBlock.simpleCodec(SaltsproutBlock::new);
    protected static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), (VoxelShape[])new VoxelShape[0]);
    public static final int MAX_AGE = 2;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)2);

    public MapCodec<SaltsproutBlock> codec() {
        return CODEC;
    }

    public SaltsproutBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)ModItems.SALTSPROUT.get());
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity) || entity.getType() == EntityType.BEE) {
            return;
        }
        if (!level.isClientSide) {
            double deltaX = Math.abs(entity.getX() - entity.xOld);
            double deltaZ = Math.abs(entity.getZ() - entity.zOld);
            if (deltaX >= (double)0.003f || deltaZ >= (double)0.003f) {
                entity.hurt(level.damageSources().cactus(), 0.5f);
            }
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        int age = (Integer)state.getValue((Property)AGE);
        if (age == 2) {
            int i = 1 + level.random.nextInt(1);
            SaltsproutBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModItems.SALTSPROUT.get(), i));
            level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            BlockState newState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1));
            level.setBlock(pos, newState, 3);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newState));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        int i = (Integer)state.getValue((Property)AGE);
        boolean flag = i == 3;
        return !flag && stack.is(Items.BONE_MEAL) ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return (Integer)blockState.getValue((Property)AGE) < 2;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        int age = Math.min(2, (Integer)blockState.getValue((Property)AGE) + 1);
        serverLevel.setBlock(blockPos, (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(age)), 2);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState blockstate = level.getBlockState(pos.relative(direction));
            if (!blockstate.isSolid() && !level.getFluidState(pos.relative(direction)).is(FluidTags.LAVA)) continue;
            return false;
        }
        BlockState blockState = level.getBlockState(pos.below());
        TriState soilDecision = blockState.canSustainPlant((BlockGetter)level, pos.below(), Direction.UP, state);
        if (!soilDecision.isDefault()) {
            return soilDecision.isTrue();
        }
        return (blockState.is(ModBlocks.INFUSED_FARMLAND) || blockState.is(BlockTags.SAND)) && !level.getBlockState(pos.above()).liquid();
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 2;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos blockpos = pos.above();
        if (level.isEmptyBlock(blockpos)) {
            int i = 1;
            while (level.getBlockState(pos.below(i)).is((Block)this)) {
                ++i;
            }
            if (i < 3) {
                int j = (Integer)state.getValue((Property)AGE);
                if (CommonHooks.canCropGrow((Level)level, (BlockPos)blockpos, (BlockState)state, (boolean)true)) {
                    if (j == 15) {
                        level.setBlockAndUpdate(blockpos, this.defaultBlockState());
                        BlockState blockstate = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0));
                        level.setBlock(pos, blockstate, 4);
                        level.neighborChanged(blockstate, blockpos, (Block)this, pos, false);
                    } else {
                        level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                    }
                    CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                }
            }
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.isAreaLoaded(pos, 1) && !state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }
}

