/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import javax.annotation.Nullable;
import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AstrylisBlockEntity
extends BlockEntity {
    private long activationTime = -1L;
    private long lastBonemealTime = -1L;

    public AstrylisBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntityTypes.ASTRYLIS.get(), pos, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AstrylisBlockEntity entity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity.isActive()) {
                long actualBonemealApplications;
                long currentTime = level.getGameTime();
                long elapsedTime = currentTime - entity.activationTime;
                int interval = (Integer)Configuration.ASTRYLIS_BONEMEAL_INTERVAL.get();
                int duration = (Integer)Configuration.ASTRYLIS_DURATION.get();
                if (elapsedTime >= (long)duration) {
                    entity.deactivate();
                    return;
                }
                long expectedBonemealApplications = elapsedTime / (long)interval;
                long l = actualBonemealApplications = entity.lastBonemealTime == -1L ? 0L : (entity.lastBonemealTime - entity.activationTime) / (long)interval + 1L;
                if (expectedBonemealApplications > actualBonemealApplications) {
                    long missedApplications = Math.min(expectedBonemealApplications - actualBonemealApplications, 5L);
                    for (long i = 0L; i < missedApplications; ++i) {
                        AstrylisBlockEntity.applyBonemealToCropsAndSaplings(serverLevel, pos);
                    }
                    entity.lastBonemealTime = currentTime;
                } else if (elapsedTime % (long)interval == 0L && elapsedTime > 0L) {
                    AstrylisBlockEntity.applyBonemealToCropsAndSaplings(serverLevel, pos);
                    entity.lastBonemealTime = currentTime;
                }
                entity.setChanged();
            }
        }
    }

    private static void applyBonemealToCropsAndSaplings(ServerLevel level, BlockPos centerPos) {
        BlockPos.betweenClosedStream((BlockPos)centerPos.offset(-4, -2, -4), (BlockPos)centerPos.offset(4, 2, 4)).forEach(pos -> {
            BlockState state = level.getBlockState(pos);
            Block patt0$temp = state.getBlock();
            if (patt0$temp instanceof BonemealableBlock) {
                BonemealableBlock bonemealableBlock = (BonemealableBlock)patt0$temp;
                if ((state.is(BlockTags.CROPS) || state.is(BlockTags.SAPLINGS)) && bonemealableBlock.isValidBonemealTarget((LevelReader)level, pos, state)) {
                    bonemealableBlock.performBonemeal(level, level.random, pos, state);
                    level.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1, 0.2, 0.2, 0.2, 0.0);
                }
            }
        });
    }

    public boolean isActive() {
        return this.activationTime > 0L && this.level != null && this.level.getGameTime() >= this.activationTime;
    }

    public void activate(long gameTime) {
        this.activationTime = gameTime;
        this.lastBonemealTime = -1L;
        this.setChanged();
    }

    public void deactivate() {
        this.activationTime = -1L;
        this.lastBonemealTime = -1L;
        this.setChanged();
    }

    public int getDuration() {
        return (Integer)Configuration.ASTRYLIS_DURATION.get();
    }

    public float getProgress() {
        if (!this.isActive() || this.level == null) {
            return 0.0f;
        }
        long elapsed = this.level.getGameTime() - this.activationTime;
        return Math.min(1.0f, (float)elapsed / (float)this.getDuration());
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putLong("activationTime", this.activationTime);
        tag.putLong("lastBonemealTime", this.lastBonemealTime);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.activationTime = tag.getLong("activationTime");
        this.lastBonemealTime = tag.getLong("lastBonemealTime");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putLong("activationTime", this.activationTime);
        tag.putLong("lastBonemealTime", this.lastBonemealTime);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

