/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import net.astralya.hexalia.block.custom.CenserBlock;
import net.astralya.hexalia.block.custom.censer.CenserEffectHandler;
import net.astralya.hexalia.block.custom.censer.HerbCombination;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.block.entity.custom.SyncBlockEntity;
import net.astralya.hexalia.util.ModUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CenserBlockEntity
extends SyncBlockEntity {
    private static final int SIZE = 2;
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private HerbCombination activeCombination = null;
    private int burnTime = 0;
    private static final int EFFECT_INTERVAL = 40;
    private boolean effectActive = false;

    public CenserBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.CENSER.get(), pos, state);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide && this.activeCombination != null && this.burnTime > 0 && !this.effectActive) {
            CenserEffectHandler.registerActiveEffect(level, pos, this.activeCombination, this.burnTime);
            this.effectActive = true;
        }
        if (!((Boolean)state.getValue((Property)CenserBlock.LIT)).booleanValue()) {
            return;
        }
        if (this.burnTime > 0) {
            --this.burnTime;
            if (this.burnTime % 40 == 0 && this.activeCombination != null) {
                CenserEffectHandler.applyEffects(level, pos, this.activeCombination);
                if (!this.effectActive) {
                    CenserEffectHandler.registerActiveEffect(level, pos, this.activeCombination, this.burnTime);
                    this.effectActive = true;
                }
            }
            if (this.burnTime <= 0) {
                this.extinguish(level, pos, state);
            }
            this.setChanged();
        }
    }

    private void extinguish(Level level, BlockPos pos, BlockState state) {
        if (this.activeCombination != null) {
            CenserEffectHandler.clearPlayerEffectsInRange(level, pos);
            CenserEffectHandler.removeActiveEffect(pos);
            this.activeCombination = null;
            this.effectActive = false;
        }
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CenserBlock.LIT, (Comparable)Boolean.valueOf(false)));
        level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 1.0f);
        this.inventoryChanged();
    }

    public void reactivateEffect() {
        if (this.activeCombination != null && this.burnTime > 0 && !this.effectActive && this.level != null) {
            CenserEffectHandler.registerActiveEffect(this.level, this.worldPosition, this.activeCombination, this.burnTime);
            this.effectActive = true;
        }
    }

    public void setBurnTime(int time) {
        this.burnTime = time;
        this.setChanged();
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public ItemStack getItem(int slot) {
        if (slot < 0 || slot >= 2) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.items.get(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot < 0 || slot >= 2) {
            return;
        }
        this.items.set(slot, (Object)stack);
        this.setChanged();
        this.sendUpdate();
    }

    public void clearItems() {
        for (int i = 0; i < 2; ++i) {
            this.items.set(i, (Object)ItemStack.EMPTY);
        }
        this.setChanged();
        this.sendUpdate();
    }

    private void sendUpdate() {
        if (this.level != null && !this.level.isClientSide()) {
            Packet<ClientGamePacketListener> updatePacket = this.getUpdatePacket();
            for (ServerPlayer player : ModUtil.tracking((ServerLevel)this.level, this.worldPosition)) {
                player.connection.send(updatePacket);
            }
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setActiveCombination(HerbCombination combo) {
        this.activeCombination = combo;
        this.inventoryChanged();
    }

    public HerbCombination getActiveCombination() {
        return this.activeCombination;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.isEmpty() || stack.getCount() > 0 && stack.getCount() <= stack.getMaxStackSize()) continue;
            stack.setCount(1);
        }
        if (tag.contains("ActiveCombination")) {
            CompoundTag comboTag = tag.getCompound("ActiveCombination");
            Item item1 = (Item)BuiltInRegistries.ITEM.byId(comboTag.getInt("Item1"));
            Item item2 = (Item)BuiltInRegistries.ITEM.byId(comboTag.getInt("Item2"));
            this.activeCombination = new HerbCombination(item1, item2);
        }
        this.burnTime = tag.getInt("BurnTime");
        this.effectActive = tag.getBoolean("EffectActive");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        tag.putInt("BurnTime", this.burnTime);
        tag.putBoolean("EffectActive", this.effectActive);
        if (this.activeCombination != null) {
            CompoundTag comboTag = new CompoundTag();
            comboTag.putInt("Item1", BuiltInRegistries.ITEM.getId((Object)this.activeCombination.item1()));
            comboTag.putInt("Item2", BuiltInRegistries.ITEM.getId((Object)this.activeCombination.item2()));
            tag.put("ActiveCombination", (Tag)comboTag);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && !this.level.isClientSide && this.activeCombination != null && this.burnTime > 0) {
            this.reactivateEffect();
        }
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Override
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(ItemStack::isEmpty);
    }

    public ItemStack removeStack(int slot) {
        if (slot < 0 || slot >= 2) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = ((ItemStack)this.items.get(slot)).copy();
        this.items.set(slot, (Object)ItemStack.EMPTY);
        this.setChanged();
        this.sendUpdate();
        return stack;
    }
}

