/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.astralya.hexalia.block.custom.RitualBrazierBlock;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.block.entity.custom.RitualBrazierBlockEntity;
import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.particle.ModParticleType;
import net.astralya.hexalia.sound.ModSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class RitualTableBlockEntity
extends BlockEntity
implements Container {
    public static final int DURATION = 160;
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return !stack.is(ModItems.HEX_FOCUS);
        }

        protected void onContentsChanged(int slot) {
            RitualTableBlockEntity.this.setChanged();
            if (RitualTableBlockEntity.this.level != null && !RitualTableBlockEntity.this.level.isClientSide()) {
                RitualTableBlockEntity.this.level.invalidateCapabilities(RitualTableBlockEntity.this.getBlockPos());
                RitualTableBlockEntity.this.level.sendBlockUpdated(RitualTableBlockEntity.this.getBlockPos(), RitualTableBlockEntity.this.getBlockState(), RitualTableBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private ItemStack cachedParticleItem = ItemStack.EMPTY;
    private List<RitualBrazierBlockEntity> activeBraziers = Collections.emptyList();
    private List<BlockPos> grownCrops = Collections.emptyList();
    private ItemStack pendingOutput = ItemStack.EMPTY;
    private int transformTicksRemaining = 0;
    private int totalTransformTicks = 0;
    private int nextBrazierIndex = 0;
    private float rotation = 0.0f;

    public RitualTableBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.RITUAL_TABLE.get(), pos, state);
    }

    public ItemStackHandler getItemHandler() {
        return this.inventory;
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).isEmpty();
    }

    public ItemStack getItem(int i) {
        return this.inventory.getStackInSlot(i);
    }

    public ItemStack removeItem(int i, int c) {
        return this.inventory.extractItem(i, c, false);
    }

    public ItemStack removeItemNoUpdate(int i) {
        return this.inventory.extractItem(i, 1, false);
    }

    public void setItem(int i, ItemStack s) {
        this.inventory.setStackInSlot(i, s.copyWithCount(1));
    }

    public boolean stillValid(Player p) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)p);
    }

    public void clearContent() {
        this.inventory.setStackInSlot(0, ItemStack.EMPTY);
    }

    public float getRenderingRotation() {
        this.rotation = (this.rotation + 0.5f) % 360.0f;
        return this.rotation;
    }

    public void startTransformation(ItemStack output, int durationTicks, List<RitualBrazierBlockEntity> braziers) {
        if (this.transformTicksRemaining > 0) {
            return;
        }
        this.totalTransformTicks = this.transformTicksRemaining = Math.max(1, durationTicks);
        this.pendingOutput = output.copy();
        this.activeBraziers = new ArrayList<RitualBrazierBlockEntity>(braziers);
        this.nextBrazierIndex = 0;
        this.setChanged();
    }

    public void setGrownCropPositions(List<BlockPos> crops) {
        this.grownCrops = new ArrayList<BlockPos>(crops);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState st, RitualTableBlockEntity be) {
        if (be.transformTicksRemaining <= 0) {
            return;
        }
        if (be.isEmpty() || RitualTableBlockEntity.hasMissingBrazierItems(be)) {
            RitualTableBlockEntity.cancelRitual(level, pos, be);
            return;
        }
        int base = be.totalTransformTicks > 0 ? be.totalTransformTicks : 160;
        int elapsed = base - be.transformTicksRemaining;
        RitualTableBlockEntity.handleActiveBraziers(level, pos, be, elapsed);
        --be.transformTicksRemaining;
        if (be.transformTicksRemaining == 0) {
            RitualTableBlockEntity.completeRitual(level, pos, be);
        }
    }

    private static boolean hasMissingBrazierItems(RitualTableBlockEntity be) {
        for (int i = be.nextBrazierIndex; i < be.activeBraziers.size(); ++i) {
            RitualBrazierBlockEntity brazier = be.activeBraziers.get(i);
            if (i == be.nextBrazierIndex && !be.cachedParticleItem.isEmpty() || brazier != null && !brazier.isRemoved() && !brazier.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static void handleActiveBraziers(Level level, BlockPos pos, RitualTableBlockEntity be, int elapsed) {
        ServerLevel server;
        if (be.activeBraziers.isEmpty() || be.nextBrazierIndex >= be.activeBraziers.size()) {
            return;
        }
        int ticksPerBrazier = 40;
        int currentTime = elapsed - be.nextBrazierIndex * ticksPerBrazier;
        RitualBrazierBlockEntity brazier = be.activeBraziers.get(be.nextBrazierIndex);
        if (brazier == null) {
            return;
        }
        if (currentTime == 0) {
            be.cachedParticleItem = brazier.getStoredItem().copy();
            brazier.removeItem();
            BlockState bs = level.getBlockState(brazier.getBlockPos());
            if (bs.getBlock() instanceof RitualBrazierBlock && bs.hasProperty((Property)RitualBrazierBlock.SALTED) && ((Boolean)bs.getValue((Property)RitualBrazierBlock.SALTED)).booleanValue()) {
                level.setBlock(brazier.getBlockPos(), (BlockState)bs.setValue((Property)RitualBrazierBlock.SALTED, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
        if (currentTime >= 0 && currentTime < ticksPerBrazier && level instanceof ServerLevel) {
            server = (ServerLevel)level;
            RitualTableBlockEntity.spawnItemParticles(server, be.cachedParticleItem, brazier.getBlockPos(), pos, currentTime, ticksPerBrazier);
        }
        if (currentTime == ticksPerBrazier - 1) {
            if (level instanceof ServerLevel) {
                server = (ServerLevel)level;
                RitualTableBlockEntity.spawnAbsorbBurst(server, pos, be.cachedParticleItem);
            }
            ++be.nextBrazierIndex;
            be.cachedParticleItem = ItemStack.EMPTY;
        }
    }

    private static void spawnItemParticles(ServerLevel server, ItemStack item, BlockPos from, BlockPos to, int time, int totalTime) {
        if (item.isEmpty()) {
            return;
        }
        ItemParticleOption particle = new ItemParticleOption(ParticleTypes.ITEM, item);
        double startX = (double)from.getX() + 0.5;
        double startY = (double)from.getY() + 0.4;
        double startZ = (double)from.getZ() + 0.5;
        double endX = (double)to.getX() + 0.5;
        double endY = (double)to.getY() + 1.15;
        double endZ = (double)to.getZ() + 0.5;
        double progress = (double)time / (double)totalTime;
        double px = startX + (endX - startX) * progress;
        double py = startY + (endY - startY) * progress;
        double pz = startZ + (endZ - startZ) * progress;
        for (int i = 0; i < 3; ++i) {
            double offsetX = (server.random.nextDouble() - 0.5) * 0.05;
            double offsetY = (server.random.nextDouble() - 0.5) * 0.05;
            double offsetZ = (server.random.nextDouble() - 0.5) * 0.05;
            double speed = 0.008 + server.random.nextDouble() * 0.004;
            double velX = (endX - startX) * speed;
            double velY = (endY - startY) * speed + 0.003;
            double velZ = (endZ - startZ) * speed;
            server.sendParticles((ParticleOptions)particle, px + offsetX, py + offsetY, pz + offsetZ, 1, velX, velY, velZ, 0.0);
        }
    }

    private static void spawnAbsorbBurst(ServerLevel server, BlockPos pos, ItemStack item) {
        double velZ;
        double velY;
        double velX;
        double offsetZ;
        double offsetY;
        double offsetX;
        int i;
        double centerX = (double)pos.getX() + 0.5;
        double centerY = (double)pos.getY() + 1.1;
        double centerZ = (double)pos.getZ() + 0.5;
        for (i = 0; i < 12; ++i) {
            offsetX = (server.random.nextDouble() - 0.5) * 0.5;
            offsetY = server.random.nextDouble() * 0.3;
            offsetZ = (server.random.nextDouble() - 0.5) * 0.5;
            velX = (server.random.nextDouble() - 0.5) * 0.02;
            velY = 0.04 + server.random.nextDouble() * 0.02;
            velZ = (server.random.nextDouble() - 0.5) * 0.02;
            server.sendParticles((ParticleOptions)ParticleTypes.WITCH, centerX + offsetX, centerY + offsetY, centerZ + offsetZ, 1, velX, velY, velZ, 0.0);
        }
        if (!item.isEmpty()) {
            for (i = 0; i < 8; ++i) {
                offsetX = (server.random.nextDouble() - 0.5) * 0.2;
                offsetY = server.random.nextDouble() * 0.2;
                offsetZ = (server.random.nextDouble() - 0.5) * 0.2;
                velX = (server.random.nextDouble() - 0.5) * 0.005;
                velY = 0.015 + server.random.nextDouble() * 0.005;
                velZ = (server.random.nextDouble() - 0.5) * 0.005;
                server.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, item), centerX + offsetX, centerY + offsetY, centerZ + offsetZ, 1, velX, velY, velZ, 0.0);
            }
        }
        server.playSound(null, pos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 0.4f, 1.2f + server.random.nextFloat() * 0.2f);
    }

    private static void completeRitual(Level level, BlockPos pos, RitualTableBlockEntity be) {
        be.setItem(0, be.pendingOutput);
        be.pendingOutput = ItemStack.EMPTY;
        for (BlockPos cropPos : be.grownCrops) {
            BlockState state = level.getBlockState(cropPos);
            Block block = state.getBlock();
            if (!(block instanceof CropBlock)) continue;
            CropBlock crop = (CropBlock)block;
            if (!state.hasProperty((Property)CropBlock.AGE)) continue;
            level.setBlock(cropPos, (BlockState)state.setValue((Property)CropBlock.AGE, (Comparable)Integer.valueOf(0)), 3);
        }
        be.activeBraziers = Collections.emptyList();
        be.nextBrazierIndex = 0;
        level.playSound(null, pos, ModSoundEvents.RITUAL_SUCCESS.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.sendParticles((ParticleOptions)ModParticleType.LEAVES.get(), (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 15, 0.3, 0.3, 0.3, 0.0);
        }
        be.setChanged();
    }

    private static void cancelRitual(Level level, BlockPos pos, RitualTableBlockEntity be) {
        be.transformTicksRemaining = 0;
        be.totalTransformTicks = 0;
        be.pendingOutput = ItemStack.EMPTY;
        be.activeBraziers = Collections.emptyList();
        be.nextBrazierIndex = 0;
        be.cachedParticleItem = ItemStack.EMPTY;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 12, 0.4, 0.4, 0.4, 0.02);
            Player nearest = server.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 5.0, false);
            if (nearest != null) {
                nearest.displayClientMessage((Component)Component.translatable((String)"message.hexalia.ritual.stopped_ritual"), true);
            }
        }
        level.playSound(null, pos, SoundEvents.CANDLE_EXTINGUISH, SoundSource.BLOCKS, 0.4f, 0.6f);
        be.setChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider regs) {
        super.saveAdditional(tag, regs);
        tag.put("Inv", (Tag)this.inventory.serializeNBT(regs));
        tag.putInt("TicksLeft", this.transformTicksRemaining);
        tag.putInt("TotalTicks", this.totalTransformTicks);
        if (!this.pendingOutput.isEmpty()) {
            tag.put("PendingOut", this.pendingOutput.save(regs));
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider regs) {
        super.loadAdditional(tag, regs);
        this.inventory.deserializeNBT(regs, tag.getCompound("Inv"));
        this.transformTicksRemaining = tag.getInt("TicksLeft");
        this.totalTransformTicks = tag.getInt("TotalTicks");
        this.pendingOutput = tag.contains("PendingOut") ? ItemStack.parseOptional((HolderLookup.Provider)regs, (CompoundTag)tag.getCompound("PendingOut")) : ItemStack.EMPTY;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider regs) {
        return this.saveWithoutMetadata(regs);
    }
}

