/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import java.util.List;
import javax.annotation.Nullable;
import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WindsongBlockEntity
extends BlockEntity {
    private int activeTicks = 0;
    private long activationTime = -1L;
    private int duration = 600;
    private int particleCooldown = 0;

    public WindsongBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntityTypes.WINDSONG.get(), pos, blockState);
    }

    public void activate() {
        this.activate((Integer)Configuration.WINDSONG_DURATION.get());
    }

    public void activate(int customDuration) {
        this.activeTicks = customDuration;
        this.duration = customDuration;
        if (this.level != null) {
            this.activationTime = this.level.getGameTime();
        }
        this.setChanged();
    }

    public boolean isActive() {
        return this.activeTicks > 0;
    }

    public int getDuration() {
        return this.duration;
    }

    public float getProgress() {
        if (this.duration <= 0) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.duration - this.activeTicks) / (float)this.duration);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WindsongBlockEntity blockEntity) {
        long currentTime;
        long elapsed;
        int expectedTicks;
        if (blockEntity.activationTime != -1L && level != null && Math.abs(blockEntity.activeTicks - (expectedTicks = blockEntity.duration - (int)(elapsed = (currentTime = level.getGameTime()) - blockEntity.activationTime))) > 5) {
            blockEntity.activeTicks = Math.max(0, expectedTicks);
        }
        if (blockEntity.isActive()) {
            --blockEntity.activeTicks;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                int radius = (Integer)Configuration.WINDSONG_EFFECT_RADIUS.get();
                AABB area = new AABB(pos).inflate((double)radius);
                List projectiles = serverLevel.getEntitiesOfClass(Entity.class, area, entity -> entity instanceof Projectile);
                for (Entity projectile : projectiles) {
                    if (projectile.isRemoved()) continue;
                    WindsongBlockEntity.discardProjectile(serverLevel, projectile);
                }
                blockEntity.emitParticles(serverLevel, pos);
            }
            if (blockEntity.activeTicks <= 0) {
                level.playSound(null, pos, (SoundEvent)SoundEvents.WIND_CHARGE_BURST.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                level.destroyBlock(pos, false);
            } else {
                blockEntity.setChanged();
            }
        }
    }

    private static void discardProjectile(ServerLevel level, Entity projectile) {
        level.playSound(null, projectile.getX(), projectile.getY(), projectile.getZ(), SoundEvents.BREEZE_DEFLECT, SoundSource.BLOCKS, 1.0f, 1.0f);
        Vec3 pos = projectile.position();
        for (int i = 0; i < 5; ++i) {
            double angle = Math.random() * 2.0 * Math.PI;
            double radius = Math.random() * 0.5;
            double x = pos.x + radius * Math.cos(angle);
            double z = pos.z + radius * Math.sin(angle);
            double y = pos.y + Math.random() * 0.5;
            level.sendParticles((ParticleOptions)ParticleTypes.EFFECT, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
        projectile.discard();
    }

    private void emitParticles(ServerLevel level, BlockPos pos) {
        if (this.particleCooldown <= 0) {
            Vec3 center = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
            float progress = this.getProgress();
            int particleCount = Math.max(1, (int)(3.0f * (1.0f - progress * 0.5f)));
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double radius = Math.random() * (double)((Integer)Configuration.WINDSONG_EFFECT_RADIUS.get()).intValue();
                double x = center.x + radius * Math.cos(angle);
                double z = center.z + radius * Math.sin(angle);
                double y = center.y + Math.random() * 2.0;
                level.sendParticles((ParticleOptions)ParticleTypes.CLOUD, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
            }
            this.particleCooldown = 5;
        } else {
            --this.particleCooldown;
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("ActiveTicks", this.activeTicks);
        tag.putLong("ActivationTime", this.activationTime);
        tag.putInt("Duration", this.duration);
        tag.putInt("ParticleCooldown", this.particleCooldown);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.activeTicks = tag.getInt("ActiveTicks");
        this.activationTime = tag.getLong("ActivationTime");
        this.duration = tag.contains("Duration") ? tag.getInt("Duration") : ((Integer)Configuration.WINDSONG_DURATION.get()).intValue();
        this.particleCooldown = tag.getInt("ParticleCooldown");
        if (this.activationTime != -1L && this.level != null && this.activeTicks > 0) {
            long currentTime = this.level.getGameTime();
            long elapsed = currentTime - this.activationTime;
            this.activeTicks = Math.max(0, this.duration - (int)elapsed);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putInt("ActiveTicks", this.activeTicks);
        tag.putLong("ActivationTime", this.activationTime);
        tag.putInt("Duration", this.duration);
        tag.putInt("ParticleCooldown", this.particleCooldown);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

