/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.compat.jei.category;

import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.recipe.MutationRecipe;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MutationRecipeCategory
implements IRecipeCategory<MutationRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"hexalia", (String)"mutation");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hexalia", (String)"textures/gui/mutation_gui.png");
    public static final RecipeType<MutationRecipe> MUTATION_RECIPE_RECIPE_TYPE = new RecipeType(UID, MutationRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable hexIcon;
    private static final int WIDTH = 118;
    private static final int HEIGHT = 80;

    public MutationRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 118, 80);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.MUTAVIS.get()));
        this.hexIcon = helper.createDrawable(TEXTURE, 0, 0, 16, 16);
    }

    public RecipeType<MutationRecipe> getRecipeType() {
        return MUTATION_RECIPE_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"item.hexalia.mutavis");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 118;
    }

    public int getHeight() {
        return 80;
    }

    public void draw(MutationRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics, 0, 0);
        this.hexIcon.draw(guiGraphics, 28, 7);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MutationRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 48, 32).addIngredients((Ingredient)recipe.getIngredients().getFirst());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 89, 31).addItemStack(recipe.getResultItem(null));
    }

    public void getTooltip(ITooltipBuilder tooltip, MutationRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 4.0 && mouseX < 20.0 && mouseY >= 55.0 && mouseY < 71.0) {
            tooltip.add((FormattedText)Component.translatable((String)"tooltip.hexalia.mutation"));
        }
    }
}

