/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.compat.patchouli;

import java.util.List;
import net.astralya.hexalia.recipe.ModRecipes;
import net.astralya.hexalia.recipe.SmallCauldronRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class SmallCauldronProcessor
implements IComponentProcessor {
    private SmallCauldronRecipe recipe;

    public void setup(Level level, IVariableProvider variables) {
        String recipeIdStr = variables.get("recipe", (HolderLookup.Provider)level.registryAccess()).asString();
        ResourceLocation recipeId = ResourceLocation.parse((String)recipeIdStr);
        List allRecipes = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipes.SMALL_CAULDRON_TYPE.get());
        this.recipe = allRecipes.stream().filter(holder -> holder.id().equals((Object)recipeId)).findFirst().map(RecipeHolder::value).orElseThrow(() -> new IllegalArgumentException("Small Cauldron recipe not found: " + String.valueOf(recipeId)));
    }

    public IVariable process(Level level, String key) {
        if (this.recipe == null) {
            return null;
        }
        switch (key) {
            case "output": {
                return IVariable.from((Object)this.recipe.getResultItem((HolderLookup.Provider)level.registryAccess()), (HolderLookup.Provider)level.registryAccess());
            }
            case "header": {
                return IVariable.from((Object)this.recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).getHoverName(), (HolderLookup.Provider)level.registryAccess());
            }
        }
        for (int i = 0; i < this.recipe.getIngredients().size(); ++i) {
            if (!key.equals("ingredients" + i)) continue;
            ItemStack[] stacks = ((Ingredient)this.recipe.getIngredients().get(i)).getItems();
            return stacks.length > 0 ? IVariable.from((Object)stacks[0], (HolderLookup.Provider)level.registryAccess()) : null;
        }
        return null;
    }
}

