/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.datagen;

import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.block.custom.RabbageCropBlock;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class ModBlockStateProvider
extends BlockStateProvider {
    private String blockName(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }

    public ResourceLocation resourceBlock(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"hexalia", (String)("block/" + path));
    }

    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "hexalia", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.blockWithItem(ModBlocks.INFUSED_DIRT);
        this.blockWithItem(ModBlocks.SALT_BLOCK);
        this.blockWithItem(ModBlocks.CELESTIAL_CRYSTAL_BLOCK);
        this.blockWithItem(ModBlocks.COTTONWOOD_PLANKS);
        this.blockWithItem(ModBlocks.WILLOW_PLANKS);
        this.waterItemBlock((Block)ModBlocks.SIREN_KELP.get());
        this.simpleCrossBlock((Block)ModBlocks.NAUTILITE.get());
        this.simpleCrossBlock((Block)ModBlocks.WITCHWEED.get());
        this.simpleCrossBlock((Block)ModBlocks.WILD_MANDRAKE.get());
        this.simpleCrossBlock((Block)ModBlocks.WILD_SUNFIRE_TOMATO.get());
        this.simpleCrossBlock((Block)ModBlocks.COTTONWOOD_CATKIN.get());
        this.blockItem(ModBlocks.COTTONWOOD_LOG);
        this.blockItem(ModBlocks.COTTONWOOD_WOOD);
        this.blockItem(ModBlocks.STRIPPED_COTTONWOOD_LOG);
        this.blockItem(ModBlocks.STRIPPED_COTTONWOOD_WOOD);
        this.blockItem(ModBlocks.WILLOW_LOG);
        this.blockItem(ModBlocks.WILLOW_WOOD);
        this.blockItem(ModBlocks.STRIPPED_WILLOW_LOG);
        this.blockItem(ModBlocks.STRIPPED_WILLOW_WOOD);
        this.flowerWithPotBlock((Block)ModBlocks.SPIRIT_BLOOM.get(), (Block)ModBlocks.POTTED_SPIRIT_BLOOM.get());
        this.flowerWithPotBlock((Block)ModBlocks.DREAMSHROOM.get(), (Block)ModBlocks.POTTED_DREAMSHROOM.get());
        this.flowerWithPotBlock((Block)ModBlocks.GHOST_FERN.get(), (Block)ModBlocks.POTTED_GHOST_FERN.get());
        this.flowerWithPotBlock((Block)ModBlocks.CELESTIAL_BLOOM.get(), (Block)ModBlocks.POTTED_CELESTIAL_BLOOM.get());
        this.flowerWithPotBlock((Block)ModBlocks.MORPHORA.get(), (Block)ModBlocks.POTTED_MORPHORA.get());
        this.flowerWithPotBlock((Block)ModBlocks.GRIMSHADE.get(), (Block)ModBlocks.POTTED_GRIMSHADE.get());
        this.flowerWithPotBlock((Block)ModBlocks.WINDSONG.get(), (Block)ModBlocks.POTTED_WINDSONG.get());
        this.flowerWithPotBlock((Block)ModBlocks.ASTRYLIS.get(), (Block)ModBlocks.POTTED_ASTRYLIS.get());
        this.flowerWithPotBlock((Block)ModBlocks.BEGONIA.get(), (Block)ModBlocks.POTTED_BEGONIA.get());
        this.flowerWithPotBlock((Block)ModBlocks.LAVENDER.get(), (Block)ModBlocks.POTTED_LAVENDER.get());
        this.flowerWithPotBlock((Block)ModBlocks.DAHLIA.get(), (Block)ModBlocks.POTTED_DAHLIA.get());
        this.flowerWithPotBlock((Block)ModBlocks.NIGHTSHADE_BUSH.get(), (Block)ModBlocks.POTTED_NIGHTSHADE_BUSH.get());
        this.flowerWithPotBlock((Block)ModBlocks.WILLOW_SAPLING.get(), (Block)ModBlocks.POTTED_WILLOW_SAPLING.get());
        this.flowerWithPotBlock((Block)ModBlocks.COTTONWOOD_SAPLING.get(), (Block)ModBlocks.POTTED_COTTONWOOD_SAPLING.get());
        this.stageBlock((Block)ModBlocks.RABBAGE_CROP.get(), RabbageCropBlock.AGE, new Property[0]);
        this.leavesBlock(ModBlocks.COTTONWOOD_LEAVES);
        this.leavesBlock(ModBlocks.WILLOW_LEAVES);
        this.logBlock((RotatedPillarBlock)ModBlocks.COTTONWOOD_LOG.get());
        this.axisBlock((RotatedPillarBlock)ModBlocks.COTTONWOOD_WOOD.get(), this.blockTexture((Block)ModBlocks.COTTONWOOD_LOG.get()), this.blockTexture((Block)ModBlocks.COTTONWOOD_LOG.get()));
        this.logBlock((RotatedPillarBlock)ModBlocks.STRIPPED_COTTONWOOD_LOG.get());
        this.axisBlock((RotatedPillarBlock)ModBlocks.STRIPPED_COTTONWOOD_WOOD.get(), this.blockTexture((Block)ModBlocks.STRIPPED_COTTONWOOD_LOG.get()), this.blockTexture((Block)ModBlocks.STRIPPED_COTTONWOOD_LOG.get()));
        this.logBlock((RotatedPillarBlock)ModBlocks.WILLOW_LOG.get());
        this.axisBlock((RotatedPillarBlock)ModBlocks.WILLOW_WOOD.get(), this.blockTexture((Block)ModBlocks.WILLOW_LOG.get()), this.blockTexture((Block)ModBlocks.WILLOW_LOG.get()));
        this.logBlock((RotatedPillarBlock)ModBlocks.STRIPPED_WILLOW_LOG.get());
        this.axisBlock((RotatedPillarBlock)ModBlocks.STRIPPED_WILLOW_WOOD.get(), this.blockTexture((Block)ModBlocks.STRIPPED_WILLOW_LOG.get()), this.blockTexture((Block)ModBlocks.STRIPPED_WILLOW_LOG.get()));
        this.stairsBlock((StairBlock)ModBlocks.COTTONWOOD_STAIRS.get(), this.blockTexture((Block)ModBlocks.COTTONWOOD_PLANKS.get()));
        this.stairsBlock((StairBlock)ModBlocks.WILLOW_STAIRS.get(), this.blockTexture((Block)ModBlocks.WILLOW_PLANKS.get()));
        this.slabBlock((SlabBlock)ModBlocks.COTTONWOOD_SLAB.get(), this.blockTexture((Block)ModBlocks.COTTONWOOD_PLANKS.get()), this.blockTexture((Block)ModBlocks.COTTONWOOD_PLANKS.get()));
        this.slabBlock((SlabBlock)ModBlocks.WILLOW_SLAB.get(), this.blockTexture((Block)ModBlocks.WILLOW_PLANKS.get()), this.blockTexture((Block)ModBlocks.WILLOW_PLANKS.get()));
        this.buttonBlock((ButtonBlock)ModBlocks.COTTONWOOD_BUTTON.get(), this.blockTexture((Block)ModBlocks.COTTONWOOD_PLANKS.get()));
        this.buttonBlock((ButtonBlock)ModBlocks.WILLOW_BUTTON.get(), this.blockTexture((Block)ModBlocks.WILLOW_PLANKS.get()));
        this.pressurePlateBlock((PressurePlateBlock)ModBlocks.COTTONWOOD_PRESSURE_PLATE.get(), this.blockTexture((Block)ModBlocks.COTTONWOOD_PLANKS.get()));
        this.pressurePlateBlock((PressurePlateBlock)ModBlocks.WILLOW_PRESSURE_PLATE.get(), this.blockTexture((Block)ModBlocks.WILLOW_PLANKS.get()));
        this.fenceBlock((FenceBlock)ModBlocks.COTTONWOOD_FENCE.get(), this.blockTexture((Block)ModBlocks.COTTONWOOD_PLANKS.get()));
        this.fenceBlock((FenceBlock)ModBlocks.WILLOW_FENCE.get(), this.blockTexture((Block)ModBlocks.WILLOW_PLANKS.get()));
        this.fenceGateBlock((FenceGateBlock)ModBlocks.COTTONWOOD_FENCE_GATE.get(), this.blockTexture((Block)ModBlocks.COTTONWOOD_PLANKS.get()));
        this.fenceGateBlock((FenceGateBlock)ModBlocks.WILLOW_FENCE_GATE.get(), this.blockTexture((Block)ModBlocks.WILLOW_PLANKS.get()));
        this.doorBlockWithRenderType((DoorBlock)ModBlocks.COTTONWOOD_DOOR.get(), this.modLoc("block/cottonwood_door_bottom"), this.modLoc("block/cottonwood_door_top"), "cutout");
        this.doorBlockWithRenderType((DoorBlock)ModBlocks.WILLOW_DOOR.get(), this.modLoc("block/willow_door_bottom"), this.modLoc("block/willow_door_top"), "cutout");
        this.trapdoorBlockWithRenderType((TrapDoorBlock)ModBlocks.COTTONWOOD_TRAPDOOR.get(), this.modLoc("block/cottonwood_trapdoor"), true, "cutout");
        this.trapdoorBlockWithRenderType((TrapDoorBlock)ModBlocks.WILLOW_TRAPDOOR.get(), this.modLoc("block/willow_trapdoor"), true, "cutout");
    }

    public void flowerWithPotBlock(Block flower, Block flowerPot) {
        String flowerName = this.blockName(flower);
        String flowerPotName = this.blockName(flowerPot);
        ModelBuilder flowerModel = ((BlockModelBuilder)this.models().cross(flowerName, this.resourceBlock(flowerName))).renderType("cutout");
        this.simpleBlock(flower, (ModelFile)flowerModel);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(flowerName)).parent((ModelFile)this.models().getExistingFile(this.mcLoc("item/generated")))).texture("layer0", this.resourceBlock(flowerName));
        this.simpleBlock(flowerPot, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(flowerPotName, this.mcLoc("block/flower_pot_cross"))).texture("plant", this.resourceBlock(flowerName))).renderType("cutout"));
    }

    public void waterItemBlock(Block block) {
        String name = this.blockName(block);
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/cross")))).texture("cross", this.resourceBlock(name))).renderType("cutout");
        this.simpleBlock(block, (ModelFile)model);
    }

    public void simpleCrossBlock(Block block) {
        String name = this.blockName(block);
        ModelBuilder model = ((BlockModelBuilder)this.models().cross(name, this.resourceBlock(name))).renderType("cutout");
        this.simpleBlock(block, (ModelFile)model);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(name)).parent((ModelFile)this.models().getExistingFile(this.mcLoc("item/generated")))).texture("layer0", this.resourceBlock(name));
    }

    public void tallPlantBlock(Block block) {
        String name = this.blockName(block);
        String bottomName = name + "_bottom";
        String topName = name + "_top";
        ModelBuilder bottomModel = ((BlockModelBuilder)this.models().cross(bottomName, this.resourceBlock(bottomName))).renderType("cutout");
        ModelBuilder topModel = ((BlockModelBuilder)this.models().cross(topName, this.resourceBlock(topName))).renderType("cutout");
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER).modelForState().modelFile((ModelFile)bottomModel).addModel()).partialState().with((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER).modelForState().modelFile((ModelFile)topModel).addModel();
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(name)).parent((ModelFile)this.models().getExistingFile(this.mcLoc("item/generated")))).texture("layer0", this.resourceBlock(topName));
    }

    private void leavesBlock(DeferredBlock<Block> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture(deferredBlock.getId().getPath(), ResourceLocation.parse((String)"minecraft:block/leaves"), "all", this.blockTexture((Block)deferredBlock.get()))).renderType("cutout"));
    }

    private void blockWithItem(DeferredBlock<Block> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), this.cubeAll((Block)deferredBlock.get()));
    }

    private void blockItem(DeferredBlock<Block> deferredBlock) {
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)new ModelFile.UncheckedModelFile("hexalia:block/" + deferredBlock.getId().getPath()));
    }

    private void blockItem(DeferredBlock<Block> deferredBlock, String appendix) {
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)new ModelFile.UncheckedModelFile("hexalia:block/" + deferredBlock.getId().getPath() + appendix));
    }

    public void stageBlock(Block block, IntegerProperty ageProperty, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int ageSuffix = (Integer)state.getValue((Property)ageProperty);
            String stageName = this.blockName(block) + "_stage" + ageSuffix;
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(stageName, this.resourceBlock(stageName))).renderType("cutout")).build();
        }, ignored);
    }
}

