/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.datagen.custom;

import java.util.LinkedHashMap;
import java.util.Map;
import net.astralya.hexalia.recipe.RitualBrazierRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class RitualBrazierRecipeBuilder
implements RecipeBuilder {
    private final Ingredient input;
    private final ItemStack output;
    private final Item result;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public RitualBrazierRecipeBuilder(Ingredient input, ItemStack output) {
        this.input = input;
        this.output = output;
        this.result = output.getItem();
    }

    public static RitualBrazierRecipeBuilder ritualBrazierRecipe(Ingredient input, ItemStack output) {
        return new RitualBrazierRecipeBuilder(input, output);
    }

    public RitualBrazierRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public RecipeBuilder group(@Nullable String s) {
        return this;
    }

    public RitualBrazierRecipeBuilder unlockedByItem(String name, Item item) {
        return this.unlockedBy(name, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{item}));
    }

    public Item getResult() {
        return this.result;
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        Advancement.Builder advancementBuilder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        RitualBrazierRecipe recipe = new RitualBrazierRecipe(this.input, this.output);
        output.accept(id, (Recipe)recipe, advancementBuilder.build(id.withPrefix("recipes/ritual_brazier/")));
    }
}

