/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.datagen.loot;

import java.util.Set;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.block.custom.ChillberryBushBlock;
import net.astralya.hexalia.block.custom.GaleberriesVineBlock;
import net.astralya.hexalia.block.custom.MandrakeCropBlock;
import net.astralya.hexalia.block.custom.RabbageCropBlock;
import net.astralya.hexalia.block.custom.SaltsproutBlock;
import net.astralya.hexalia.block.custom.SunfireTomatoCropBlock;
import net.astralya.hexalia.item.ModItems;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class ModBlockLootTableProvider
extends BlockLootSubProvider {
    public ModBlockLootTableProvider(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected void generate() {
        this.generatePlantsAndFlowers();
        this.generateFunctionalBlocks();
        this.generateCrops();
        this.generateTreeBlocks();
    }

    private void generatePlantsAndFlowers() {
        this.dropSelf((Block)ModBlocks.SPIRIT_BLOOM.get());
        this.dropSelf((Block)ModBlocks.DREAMSHROOM.get());
        this.dropSelf((Block)ModBlocks.LOTUS_FLOWER.get());
        this.dropSelf((Block)ModBlocks.WITCHWEED.get());
        this.dropSelf((Block)ModBlocks.GHOST_FERN.get());
        this.dropSelf((Block)ModBlocks.CELESTIAL_BLOOM.get());
        this.dropSelf((Block)ModBlocks.NIGHTSHADE_BUSH.get());
        this.dropSelf((Block)ModBlocks.BEGONIA.get());
        this.dropSelf((Block)ModBlocks.LAVENDER.get());
        this.dropSelf((Block)ModBlocks.MORPHORA.get());
        this.dropSelf((Block)ModBlocks.GRIMSHADE.get());
        this.dropSelf((Block)ModBlocks.NAUTILITE.get());
        this.dropSelf((Block)ModBlocks.WINDSONG.get());
        this.dropSelf((Block)ModBlocks.ASTRYLIS.get());
        this.dropSelf((Block)ModBlocks.DAHLIA.get());
        this.add((Block)ModBlocks.POTTED_SPIRIT_BLOOM.get(), this.createPotFlowerItemTable((ItemLike)ModBlocks.SPIRIT_BLOOM.get()));
        this.add((Block)ModBlocks.POTTED_DREAMSHROOM.get(), this.createPotFlowerItemTable((ItemLike)ModBlocks.DREAMSHROOM.get()));
        this.add((Block)ModBlocks.POTTED_GHOST_FERN.get(), this.createPotFlowerItemTable((ItemLike)ModBlocks.GHOST_FERN.get()));
        this.add((Block)ModBlocks.POTTED_CELESTIAL_BLOOM.get(), this.createPotFlowerItemTable((ItemLike)ModBlocks.CELESTIAL_BLOOM.get()));
        this.add((Block)ModBlocks.POTTED_NIGHTSHADE_BUSH.get(), this.createPotFlowerItemTable((ItemLike)ModBlocks.NIGHTSHADE_BUSH.get()));
        this.add((Block)ModBlocks.POTTED_BEGONIA.get(), this.createPotFlowerItemTable((ItemLike)ModBlocks.BEGONIA.get()));
        this.add((Block)ModBlocks.POTTED_LAVENDER.get(), this.createPotFlowerItemTable((ItemLike)ModBlocks.LAVENDER.get()));
        this.add((Block)ModBlocks.POTTED_DAHLIA.get(), this.createPotFlowerItemTable((ItemLike)ModBlocks.DAHLIA.get()));
        this.add((Block)ModBlocks.POTTED_MORPHORA.get(), this.createPotFlowerItemTable((ItemLike)ModBlocks.MORPHORA.get()));
        this.add((Block)ModBlocks.POTTED_GRIMSHADE.get(), this.createPotFlowerItemTable((ItemLike)ModBlocks.GRIMSHADE.get()));
        this.add((Block)ModBlocks.POTTED_WINDSONG.get(), this.createPotFlowerItemTable((ItemLike)ModBlocks.WINDSONG.get()));
        this.add((Block)ModBlocks.POTTED_ASTRYLIS.get(), this.createPotFlowerItemTable((ItemLike)ModBlocks.ASTRYLIS.get()));
        this.add((Block)ModBlocks.SIREN_KELP.get(), this.createSingleItemTable((ItemLike)ModItems.SIREN_KELP.get()));
        this.add((Block)ModBlocks.COTTONWOOD_CATKIN.get(), this.createSingleItemTable((ItemLike)Items.STRING));
        this.add((Block)ModBlocks.GALEBERRIES_VINE.get(), ModBlockLootTableProvider.vinesDrop((Block)ModBlocks.GALEBERRIES_VINE.get()));
        this.add((Block)ModBlocks.GALEBERRIES_VINE_PLANT.get(), ModBlockLootTableProvider.vinesDrop((Block)ModBlocks.GALEBERRIES_VINE_PLANT.get()));
        this.add((Block)ModBlocks.PALE_MUSHROOM.get(), this.createPetalsDrops((Block)ModBlocks.PALE_MUSHROOM.get()));
    }

    private void generateFunctionalBlocks() {
        this.dropSelf((Block)ModBlocks.RITUAL_BRAZIER.get());
        this.dropSelf((Block)ModBlocks.INFUSED_DIRT.get());
        this.dropSelf((Block)ModBlocks.SALT_LAMP.get());
        this.dropSelf((Block)ModBlocks.CANDLE_SKULL.get());
        this.dropSelf((Block)ModBlocks.WITHER_CANDLE_SKULL.get());
        this.dropSelf((Block)ModBlocks.DREAMCATCHER.get());
        this.dropSelf((Block)ModBlocks.RUSTIC_OVEN.get());
        this.dropSelf((Block)ModBlocks.SMALL_CAULDRON.get());
        this.dropSelf((Block)ModBlocks.CELESTIAL_CRYSTAL_BLOCK.get());
        this.dropSelf((Block)ModBlocks.SHELF.get());
        this.dropSelf((Block)ModBlocks.CENSER.get());
        this.add((Block)ModBlocks.INFUSED_FARMLAND.get(), this.createSingleItemTable((ItemLike)ModBlocks.INFUSED_DIRT.get()));
        this.add((Block)ModBlocks.RITUAL_TABLE.get(), this.createSingleItemTable((ItemLike)ModBlocks.RITUAL_TABLE.get()));
        this.add((Block)ModBlocks.SALT_BLOCK.get(), block -> this.createOreDrop((Block)ModBlocks.SALT_BLOCK.get(), (Item)ModItems.SALT.get()));
        this.add((Block)ModBlocks.SILKWORM_COCOON.get(), this.createSingleItemTable((ItemLike)ModItems.SILKWORM.get()));
    }

    private void generateCrops() {
        this.add((Block)ModBlocks.WILD_SUNFIRE_TOMATO.get(), this.createSingleItemTable((ItemLike)ModItems.SUNFIRE_TOMATO_SEEDS.get()));
        this.add((Block)ModBlocks.WILD_MANDRAKE.get(), this.createSingleItemTable((ItemLike)ModItems.MANDRAKE_SEEDS.get()));
        LootItemBlockStatePropertyCondition.Builder lootItemCondition$builder1 = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)ModBlocks.MANDRAKE_CROP.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)MandrakeCropBlock.AGE, 3));
        this.add((Block)ModBlocks.MANDRAKE_CROP.get(), this.createCropDrops((Block)ModBlocks.MANDRAKE_CROP.get(), (Item)ModItems.MANDRAKE.get(), (Item)ModItems.MANDRAKE_SEEDS.get(), (LootItemCondition.Builder)lootItemCondition$builder1));
        LootItemBlockStatePropertyCondition.Builder lootItemCondition$builder2 = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)ModBlocks.SUNFIRE_TOMATO_CROP.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SunfireTomatoCropBlock.AGE, 3));
        this.add((Block)ModBlocks.SUNFIRE_TOMATO_CROP.get(), this.createCropDrops((Block)ModBlocks.SUNFIRE_TOMATO_CROP.get(), (Item)ModItems.SUNFIRE_TOMATO.get(), (Item)ModItems.SUNFIRE_TOMATO_SEEDS.get(), (LootItemCondition.Builder)lootItemCondition$builder2));
        LootItemBlockStatePropertyCondition.Builder lootItemCondition$builder3 = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)ModBlocks.RABBAGE_CROP.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)RabbageCropBlock.AGE, 3));
        this.add((Block)ModBlocks.RABBAGE_CROP.get(), this.createCropDrops((Block)ModBlocks.RABBAGE_CROP.get(), (Item)ModItems.RABBAGE.get(), (Item)ModItems.RABBAGE_SEEDS.get(), (LootItemCondition.Builder)lootItemCondition$builder3));
        LootItemBlockStatePropertyCondition.Builder lootItemCondition$builder4 = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)ModBlocks.SALTSPROUT.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SaltsproutBlock.AGE, 2));
        this.add((Block)ModBlocks.SALTSPROUT.get(), this.createSimpleCropBlock((Block)ModBlocks.SALTSPROUT.get(), (Item)ModItems.SALTSPROUT.get(), (LootItemCondition.Builder)lootItemCondition$builder4));
        this.add((Block)ModBlocks.CHILLBERRY_BUSH.get(), this.createBerryBushDrops((Block)ModBlocks.CHILLBERRY_BUSH.get(), (Item)ModItems.CHILLBERRIES.get()));
    }

    private void generateTreeBlocks() {
        this.add((Block)ModBlocks.COTTONWOOD_LEAVES.get(), this.createLeavesDrops((Block)ModBlocks.COTTONWOOD_LEAVES.get(), (Block)ModBlocks.COTTONWOOD_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf((Block)ModBlocks.COTTONWOOD_LOG.get());
        this.dropSelf((Block)ModBlocks.COTTONWOOD_WOOD.get());
        this.dropSelf((Block)ModBlocks.STRIPPED_COTTONWOOD_LOG.get());
        this.dropSelf((Block)ModBlocks.STRIPPED_COTTONWOOD_WOOD.get());
        this.dropSelf((Block)ModBlocks.COTTONWOOD_PLANKS.get());
        this.dropSelf((Block)ModBlocks.COTTONWOOD_SAPLING.get());
        this.add((Block)ModBlocks.POTTED_COTTONWOOD_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)ModBlocks.COTTONWOOD_SAPLING.get()));
        this.dropSelf((Block)ModBlocks.COTTONWOOD_STAIRS.get());
        this.dropSelf((Block)ModBlocks.COTTONWOOD_PRESSURE_PLATE.get());
        this.add((Block)ModBlocks.COTTONWOOD_SLAB.get(), this.createSlabItemTable((Block)ModBlocks.COTTONWOOD_SLAB.get()));
        this.dropSelf((Block)ModBlocks.COTTONWOOD_BUTTON.get());
        this.dropSelf((Block)ModBlocks.COTTONWOOD_FENCE.get());
        this.dropSelf((Block)ModBlocks.COTTONWOOD_FENCE_GATE.get());
        this.dropSelf((Block)ModBlocks.COTTONWOOD_TRAPDOOR.get());
        this.add((Block)ModBlocks.COTTONWOOD_DOOR.get(), this.createDoorTable((Block)ModBlocks.COTTONWOOD_DOOR.get()));
        this.add((Block)ModBlocks.COTTONWOOD_SIGN.get(), this.createSingleItemTable((ItemLike)ModBlocks.COTTONWOOD_SIGN.get()));
        this.add((Block)ModBlocks.COTTONWOOD_WALL_SIGN.get(), this.createSingleItemTable((ItemLike)ModBlocks.COTTONWOOD_SIGN.get()));
        this.add((Block)ModBlocks.COTTONWOOD_HANGING_SIGN.get(), this.createSingleItemTable((ItemLike)ModBlocks.COTTONWOOD_HANGING_SIGN.get()));
        this.add((Block)ModBlocks.COTTONWOOD_HANGING_WALL_SIGN.get(), this.createSingleItemTable((ItemLike)ModBlocks.COTTONWOOD_HANGING_SIGN.get()));
        this.add((Block)ModBlocks.WILLOW_LEAVES.get(), this.createLeavesDrops((Block)ModBlocks.WILLOW_LEAVES.get(), (Block)ModBlocks.WILLOW_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf((Block)ModBlocks.WILLOW_LOG.get());
        this.dropSelf((Block)ModBlocks.WILLOW_WOOD.get());
        this.dropSelf((Block)ModBlocks.STRIPPED_WILLOW_LOG.get());
        this.dropSelf((Block)ModBlocks.STRIPPED_WILLOW_WOOD.get());
        this.dropSelf((Block)ModBlocks.WILLOW_PLANKS.get());
        this.dropSelf((Block)ModBlocks.WILLOW_SAPLING.get());
        this.add((Block)ModBlocks.POTTED_WILLOW_SAPLING.get(), this.createPotFlowerItemTable((ItemLike)ModBlocks.WILLOW_SAPLING.get()));
        this.dropSelf((Block)ModBlocks.WILLOW_STAIRS.get());
        this.dropSelf((Block)ModBlocks.WILLOW_PRESSURE_PLATE.get());
        this.add((Block)ModBlocks.WILLOW_SLAB.get(), this.createSlabItemTable((Block)ModBlocks.WILLOW_SLAB.get()));
        this.dropSelf((Block)ModBlocks.WILLOW_BUTTON.get());
        this.dropSelf((Block)ModBlocks.WILLOW_FENCE.get());
        this.dropSelf((Block)ModBlocks.WILLOW_FENCE_GATE.get());
        this.dropSelf((Block)ModBlocks.WILLOW_TRAPDOOR.get());
        this.add((Block)ModBlocks.WILLOW_DOOR.get(), this.createDoorTable((Block)ModBlocks.WILLOW_DOOR.get()));
        this.add((Block)ModBlocks.WILLOW_SIGN.get(), this.createSingleItemTable((ItemLike)ModBlocks.WILLOW_SIGN.get()));
        this.add((Block)ModBlocks.WILLOW_WALL_SIGN.get(), this.createSingleItemTable((ItemLike)ModBlocks.WILLOW_SIGN.get()));
        this.add((Block)ModBlocks.WILLOW_HANGING_SIGN.get(), this.createSingleItemTable((ItemLike)ModBlocks.WILLOW_HANGING_SIGN.get()));
        this.add((Block)ModBlocks.WILLOW_HANGING_WALL_SIGN.get(), this.createSingleItemTable((ItemLike)ModBlocks.WILLOW_HANGING_SIGN.get()));
    }

    protected LootTable.Builder createSimpleCropBlock(Block pCropBlock, Item pGrownCropItem, LootItemCondition.Builder pDropGrownCropCondition) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return (LootTable.Builder)this.applyExplosionDecay((ItemLike)pCropBlock, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)pGrownCropItem).when(pDropGrownCropCondition)).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float)0.5714286f, (int)3)))));
    }

    protected LootTable.Builder createBerryBushDrops(Block bushBlock, Item chillberryItem) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        LootItemBlockStatePropertyCondition.Builder age3Condition = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)bushBlock).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)ChillberryBushBlock.AGE, 3));
        LootItemBlockStatePropertyCondition.Builder age2Condition = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)bushBlock).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)ChillberryBushBlock.AGE, 2));
        return (LootTable.Builder)this.applyExplosionDecay((ItemLike)bushBlock, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)chillberryItem).when((LootItemCondition.Builder)age3Condition)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float)1.0f, (int)3)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)chillberryItem).when((LootItemCondition.Builder)age2Condition)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float)1.0f, (int)3)))));
    }

    protected static LootTable.Builder vinesDrop(Block pBlock) {
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.GALEBERRIES.get()))).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)pBlock).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)GaleberriesVineBlock.BERRIES, true))));
    }

    protected Iterable<Block> getKnownBlocks() {
        return ModBlocks.BLOCKS.getEntries().stream().map(Holder::value)::iterator;
    }
}

