/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.entity.custom.projectile;

import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.effect.cloud.FoulCloud;
import net.astralya.hexalia.entity.ModEntities;
import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.sound.ModSoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class FoulSacProjectile
extends ThrowableItemProjectile {
    public FoulSacProjectile(EntityType<? extends FoulSacProjectile> type, Level level) {
        super(type, level);
    }

    public FoulSacProjectile(Level level) {
        super(ModEntities.FOUL_SAC.get(), level);
    }

    public FoulSacProjectile(Level level, LivingEntity owner) {
        super(ModEntities.FOUL_SAC.get(), owner, level);
    }

    protected Item getDefaultItem() {
        return (Item)ModItems.FOUL_SAC.get();
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    protected void onHit(HitResult hit) {
        super.onHit(hit);
        if (!this.level().isClientSide) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), ModSoundEvents.SAC_IMPACT.get(), SoundSource.PLAYERS, 0.9f, 0.8f + this.level().getRandom().nextFloat() * 0.4f);
            int durationSeconds = Math.max(1, (Integer)Configuration.FOUL_SAC_DURATION.get());
            FoulCloud cloud = new FoulCloud(this.level(), this.getX(), this.getY(), this.getZ(), durationSeconds);
            Entity entity = this.getOwner();
            if (entity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity;
                cloud.setCloudOwner(le);
            }
            this.level().addFreshEntity((Entity)cloud);
            this.discard();
        }
    }
}

