/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.item.custom;

import com.mojang.serialization.MapCodec;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class CustomModelSpawnEggItem
extends Item {
    private static final MapCodec<EntityType<?>> ENTITY_TYPE_FIELD_CODEC = BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("id");
    private final EntityType<?> defaultType;

    public CustomModelSpawnEggItem(EntityType<? extends Mob> defaultType, Item.Properties properties) {
        super(properties);
        this.defaultType = defaultType;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel server = (ServerLevel)level;
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        BlockState state = level.getBlockState(pos);
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof Spawner) {
            Spawner spawner = (Spawner)be;
            EntityType<?> type = this.getType(stack);
            spawner.setEntityId(type, level.getRandom());
            level.sendBlockUpdated(pos, state, state, 3);
            level.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.BLOCK_CHANGE, pos);
            stack.shrink(1);
            return InteractionResult.CONSUME;
        }
        BlockPos spawnPos = state.getCollisionShape((BlockGetter)level, pos).isEmpty() ? pos : pos.relative(face);
        EntityType<?> type = this.getType(stack);
        if (type.spawn(server, stack, context.getPlayer(), spawnPos, MobSpawnType.SPAWN_EGG, true, !Objects.equals(pos, spawnPos) && face == Direction.UP) != null) {
            stack.shrink(1);
            level.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, pos);
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        BlockHitResult hit = CustomModelSpawnEggItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hit.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.success((Object)stack);
        }
        ServerLevel server = (ServerLevel)level;
        BlockPos pos = hit.getBlockPos();
        if (!(level.getBlockState(pos).getBlock() instanceof LiquidBlock)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (level.mayInteract(player, pos) && player.mayUseItemAt(pos, hit.getDirection(), stack)) {
            EntityType<?> type = this.getType(stack);
            Entity entity = type.spawn(server, stack, player, pos, MobSpawnType.SPAWN_EGG, false, false);
            if (entity == null) {
                return InteractionResultHolder.pass((Object)stack);
            }
            stack.consume(1, (LivingEntity)player);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, entity.position());
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public boolean spawnsEntity(ItemStack stack, EntityType<?> entityType) {
        return Objects.equals(this.getType(stack), entityType);
    }

    public EntityType<?> getType(ItemStack stack) {
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
        return !data.isEmpty() ? data.read(ENTITY_TYPE_FIELD_CODEC).result().orElse(this.getDefaultType()) : this.getDefaultType();
    }

    public Optional<Mob> spawnOffspringFromSpawnEgg(Player player, Mob parent, EntityType<? extends Mob> entityType, ServerLevel serverLevel, Vec3 pos, ItemStack stack) {
        Mob baby;
        if (!this.spawnsEntity(stack, entityType)) {
            return Optional.empty();
        }
        if (parent instanceof AgeableMob) {
            AgeableMob ageable = (AgeableMob)parent;
            v0 = ageable.getBreedOffspring(serverLevel, ageable);
        } else {
            v0 = baby = (Mob)entityType.create((Level)serverLevel);
        }
        if (baby == null) {
            return Optional.empty();
        }
        baby.setBaby(true);
        if (!baby.isBaby()) {
            return Optional.empty();
        }
        baby.moveTo(pos.x(), pos.y(), pos.z(), 0.0f, 0.0f);
        serverLevel.addFreshEntityWithPassengers((Entity)baby);
        baby.setCustomName((Component)stack.get(DataComponents.CUSTOM_NAME));
        stack.consume(1, (LivingEntity)player);
        return Optional.of(baby);
    }

    public FeatureFlagSet requiredFeatures() {
        return this.getDefaultType().requiredFeatures();
    }

    protected EntityType<?> getDefaultType() {
        return this.defaultType;
    }
}

