/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.item.custom;

import net.astralya.hexalia.item.custom.WeatherIdolItem;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;

public class PurityIdolItem
extends WeatherIdolItem {
    public PurityIdolItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity user) {
        if (!level.isClientSide) {
            ItemStack main = user.getMainHandItem();
            ItemStack off = user.getOffhandItem();
            ItemStack target = stack == main ? off : main;
            boolean removed = this.removeCurses(target);
            if (removed) {
                level.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 1.0f, 1.2f);
                if (user instanceof Player) {
                    Player player = (Player)user;
                    if (!player.getAbilities().instabuild) {
                        stack.shrink(1);
                    }
                }
            }
        }
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, stack);
        }
        return stack;
    }

    private boolean removeCurses(ItemStack target) {
        if (target.isEmpty()) {
            return false;
        }
        ItemEnchantments ench = (ItemEnchantments)target.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        if (ench.isEmpty()) {
            return false;
        }
        ItemEnchantments.Mutable mut = new ItemEnchantments.Mutable(ench);
        int before = mut.keySet().size();
        mut.removeIf(holder -> holder.is(EnchantmentTags.CURSE));
        int after = mut.keySet().size();
        if (after < before) {
            target.set(DataComponents.ENCHANTMENTS, (Object)mut.toImmutable());
            return true;
        }
        return false;
    }
}

