/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.mixin;

import java.util.Objects;
import net.astralya.hexalia.effect.ModMobEffects;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Unique
    private final LivingEntity hexalia$livingEntity = (LivingEntity)this;

    @Inject(at={@At(value="HEAD")}, method={"hurt"})
    public void damageMixin(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        float healthStealAmount;
        Player player;
        Entity entity = source.getEntity();
        if (entity instanceof Player && (player = (Player)entity).hasEffect(ModMobEffects.BLOODLUST) && (healthStealAmount = Math.min(6.0f, amount / 4.0f)) >= 1.0f) {
            player.playSound(SoundEvents.NETHER_WART_BREAK, 1.0f, 1.0f);
            player.heal(healthStealAmount);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"getDamageAfterArmorAbsorb"})
    public void returnDamage(DamageSource source, float amount, CallbackInfoReturnable<Float> cir) {
        float newAmount = ((Float)cir.getReturnValue()).floatValue();
        Entity attacker = source.getEntity();
        if (this.hexalia$livingEntity.hasEffect(ModMobEffects.SPIKESKIN) && attacker instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            livingAttacker.hurt(livingAttacker.damageSources().indirectMagic((Entity)livingAttacker, (Entity)this.hexalia$livingEntity), (float)((double)newAmount * 0.2) + (float)Objects.requireNonNull(this.hexalia$livingEntity.getEffect(ModMobEffects.SPIKESKIN)).getAmplifier() + 1.0f);
        }
    }
}

