/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.mixin;

import net.astralya.hexalia.block.custom.censer.CenserEffectHandler;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MobMixin
extends LivingEntity {
    @Unique
    private int hexalia$lastCheckTick = -100;
    @Unique
    private boolean hexalia$lastCheckResult = false;

    protected MobMixin(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    @Inject(method={"getTarget"}, at={@At(value="RETURN")}, cancellable=true)
    private void hexalia$preventTargetGetting(CallbackInfoReturnable<LivingEntity> cir) {
        LivingEntity target;
        if (this.shouldIgnorePlayers() && (target = (LivingEntity)cir.getReturnValue()) instanceof Player) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"setTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void hexalia$preventTargetSetting(LivingEntity target, CallbackInfo ci) {
        if (this.shouldIgnorePlayers() && target instanceof Player) {
            ci.cancel();
        }
    }

    @Unique
    private boolean shouldIgnorePlayers() {
        if (!(this instanceof Monster) || this.isExcludedBoss((Object)this)) {
            return false;
        }
        int currentTick = this.tickCount;
        if (currentTick - this.hexalia$lastCheckTick < 10) {
            return this.hexalia$lastCheckResult;
        }
        this.hexalia$lastCheckTick = currentTick;
        this.hexalia$lastCheckResult = CenserEffectHandler.isUndeadVeilActiveInArea(this.level(), this.blockPosition());
        return this.hexalia$lastCheckResult;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void hexalia$resetCheck(CallbackInfo ci) {
        if (this.tickCount % 100 == 0) {
            this.hexalia$lastCheckTick = -100;
            this.hexalia$lastCheckResult = false;
        }
    }

    @Unique
    private boolean isExcludedBoss(Object entity) {
        return entity instanceof EnderDragon || entity instanceof WitherBoss || entity instanceof Warden;
    }
}

