/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import net.astralya.hexalia.recipe.ModRecipes;
import net.astralya.hexalia.recipe.RitualTableRecipeInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record RitualTableRecipe(NonNullList<Ingredient> ingredients, ItemStack output) implements Recipe<RitualTableRecipeInput>
{
    public static final int INPUT_SLOTS = 4;

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean matches(RitualTableRecipeInput inv, Level lvl) {
        if (lvl.isClientSide()) {
            return false;
        }
        if (this.ingredients.isEmpty() || !((Ingredient)this.ingredients.get(0)).test(inv.getItem(0))) {
            return false;
        }
        if (this.ingredients.size() == 1) {
            return true;
        }
        return true;
    }

    public ItemStack assemble(RitualTableRecipeInput inv, HolderLookup.Provider reg) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.RITUAL_TABLE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.RITUAL_TABLE_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<RitualTableRecipe> {
        public static final MapCodec<RitualTableRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.LIST_CODEC_NONEMPTY.fieldOf("ingredients").xmap(list -> {
            NonNullList nn = NonNullList.create();
            nn.addAll((Collection)list);
            return nn;
        }, list -> list).forGetter(RitualTableRecipe::ingredients), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("output").xmap(ItemStack::new, ItemStack::getItem).forGetter(RitualTableRecipe::output)).apply((Applicative)inst, RitualTableRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, RitualTableRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
            buf.writeVarInt(recipe.ingredients.size());
            for (Ingredient ing : recipe.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)ing);
            }
            ItemStack.STREAM_CODEC.encode(buf, (Object)recipe.output);
        }, buf -> {
            int count = buf.readVarInt();
            NonNullList list = NonNullList.withSize((int)count, (Object)Ingredient.EMPTY);
            for (int i = 0; i < count; ++i) {
                list.set(i, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf)));
            }
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
            return new RitualTableRecipe((NonNullList<Ingredient>)list, output);
        });

        public MapCodec<RitualTableRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RitualTableRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static RitualTableRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            int count = buffer.readVarInt();
            NonNullList ingredientsList = NonNullList.withSize((int)count, (Object)Ingredient.EMPTY);
            ingredientsList.replaceAll(ing -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            ItemStack outputStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new RitualTableRecipe((NonNullList<Ingredient>)ingredientsList, outputStack);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, RitualTableRecipe recipe) {
            buffer.writeVarInt(recipe.ingredients.size());
            for (Ingredient ing : recipe.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ing);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
        }
    }
}

