/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.recipe.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public class SmallCauldronRecipe
implements Recipe<RecipeWrapper> {
    public static final int INPUT_SLOTS = 3;
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack output;
    private final Ingredient bottleSlot;
    private final float experience;
    private final int brewTime;

    public SmallCauldronRecipe(NonNullList<Ingredient> ingredients, Ingredient bottleSlot, ItemStack output, float experience, int brewTime) {
        this.ingredients = ingredients;
        this.bottleSlot = bottleSlot;
        this.output = output;
        this.experience = experience;
        this.brewTime = brewTime;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public Ingredient getBottleSlot() {
        return this.bottleSlot;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getBrewTime() {
        return this.brewTime;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output;
    }

    public boolean matches(RecipeWrapper inv, Level level) {
        int inputsCount = 0;
        for (int j = 0; j < 3; ++j) {
            if (inv.getItem(j).isEmpty()) continue;
            ++inputsCount;
        }
        if (inputsCount != this.ingredients.size()) {
            return false;
        }
        boolean[] slotUsed = new boolean[3];
        for (Ingredient ingredient : this.ingredients) {
            boolean found = false;
            for (int j = 0; j < 3; ++j) {
                if (slotUsed[j] || !ingredient.test(inv.getItem(j))) continue;
                slotUsed[j] = true;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        ItemStack bottleInSlot = inv.getItem(4);
        return this.bottleSlot.test(bottleInSlot);
    }

    public ItemStack assemble(RecipeWrapper inv, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.SMALL_CAULDRON_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.SMALL_CAULDRON_TYPE.get();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModItems.SMALL_CAULDRON.get());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmallCauldronRecipe that = (SmallCauldronRecipe)o;
        if (Float.compare(that.getExperience(), this.getExperience()) != 0) {
            return false;
        }
        if (this.getBrewTime() != that.getBrewTime()) {
            return false;
        }
        if (!this.getGroup().equals(that.getGroup())) {
            return false;
        }
        if (!this.ingredients.equals(that.ingredients)) {
            return false;
        }
        if (!this.output.equals(that.output)) {
            return false;
        }
        return this.bottleSlot.equals((Object)that.bottleSlot);
    }

    public int hashCode() {
        int result = this.getGroup().hashCode();
        result = 31 * result + this.ingredients.hashCode();
        result = 31 * result + this.output.hashCode();
        result = 31 * result + this.bottleSlot.hashCode();
        result = 31 * result + (this.getExperience() != 0.0f ? Float.floatToIntBits(this.getExperience()) : 0);
        result = 31 * result + this.getBrewTime();
        return result;
    }

    public static class Serializer
    implements RecipeSerializer<SmallCauldronRecipe> {
        private static final MapCodec<SmallCauldronRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.LIST_CODEC_NONEMPTY.fieldOf("ingredients").xmap(ingredients -> {
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)ingredients);
            return nonNullList;
        }, ingredients -> ingredients).forGetter(SmallCauldronRecipe::getIngredients), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(r -> r.output), (App)Ingredient.CODEC.fieldOf("bottle_slot").forGetter(SmallCauldronRecipe::getBottleSlot), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(SmallCauldronRecipe::getExperience), (App)Codec.INT.optionalFieldOf("brewtime", (Object)200).forGetter(SmallCauldronRecipe::getBrewTime)).apply((Applicative)inst, (ingredients, output, bottle, experience, time) -> new SmallCauldronRecipe((NonNullList<Ingredient>)ingredients, (Ingredient)bottle, (ItemStack)output, experience.floatValue(), (int)time)));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmallCauldronRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<SmallCauldronRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SmallCauldronRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static SmallCauldronRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            int i = buffer.readVarInt();
            NonNullList inputItemsIn = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            inputItemsIn.replaceAll(ignored -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            ItemStack outputIn = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            Ingredient bottleSlot = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            float experienceerienceIn = buffer.readFloat();
            int brewTimeIn = buffer.readVarInt();
            return new SmallCauldronRecipe((NonNullList<Ingredient>)inputItemsIn, bottleSlot, outputIn, experienceerienceIn, brewTimeIn);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, SmallCauldronRecipe recipe) {
            buffer.writeVarInt(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.bottleSlot);
            buffer.writeFloat(recipe.experience);
            buffer.writeVarInt(recipe.brewTime);
        }
    }
}

