/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.screen.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import net.astralya.hexalia.screen.custom.SmallCauldronMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SmallCauldronScreen
extends AbstractContainerScreen<SmallCauldronMenu> {
    public static final Rect2i PROGRESS = new Rect2i(89, 25, 0, 17);
    public static final Rect2i HEAT = new Rect2i(124, 52, 17, 15);
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hexalia", (String)"textures/gui/small_cauldron_gui.png");

    public SmallCauldronScreen(SmallCauldronMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void init() {
        super.init();
        this.titleLabelX = 1000;
        this.titleLabelY = 1000;
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.renderElements(guiGraphics, x, y);
    }

    private void renderElements(GuiGraphics guiGraphics, int x, int y) {
        if (((SmallCauldronMenu)this.menu).isCrafting()) {
            int h = ((SmallCauldronMenu)this.menu).getScaledProgress();
            guiGraphics.blit(GUI_TEXTURE, x + PROGRESS.getX(), y + PROGRESS.getY(), 176, 15, h + 1, PROGRESS.getHeight());
        }
        if (((SmallCauldronMenu)this.menu).isHeated()) {
            guiGraphics.blit(GUI_TEXTURE, x + HEAT.getX(), y + HEAT.getY(), 176, 0, HEAT.getWidth(), HEAT.getHeight());
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }
}

