/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.block.entity;

import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.grapes.hexalia.block.entity.ModBlockEntities;
import net.grapes.hexalia.networking.ModMessages;
import net.grapes.hexalia.recipe.RitualBrazierRecipe;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class RitualBrazierBlockEntity
extends class_2586
implements class_1278 {
    private static final int MOONLIGHT_DURATION = 400;
    private static final class_2338.class_2339 mutablePos = new class_2338.class_2339();
    private int timer = 0;
    private boolean active = false;
    private class_2371<class_1799> inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);

    public RitualBrazierBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.RITUAL_BRAZIER_BE, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, RitualBrazierBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        if (blockEntity.active && !blockEntity.method_5442()) {
            class_1799 itemStack = blockEntity.method_5438(0);
            Optional recipe = world.method_8433().method_8132((class_3956)RitualBrazierRecipe.Type.INSTANCE, (class_1263)new class_1277(new class_1799[]{itemStack}), world);
            if (recipe.isPresent()) {
                if (RitualBrazierBlockEntity.isNight(world, pos)) {
                    ++blockEntity.timer;
                    if (blockEntity.timer >= 400) {
                        blockEntity.method_5447(0, class_1799.field_8037);
                        blockEntity.timer = 0;
                        blockEntity.setActive(false);
                        blockEntity.method_5431();
                        class_1799 resultStack = ((RitualBrazierRecipe)recipe.get()).method_8110(world.method_30349()).method_7972();
                        class_1264.method_5449((class_1937)world, (double)((double)pos.method_10263() + 0.5), (double)((double)pos.method_10264() + 1.0), (double)((double)pos.method_10260() + 0.5), (class_1799)resultStack);
                        RitualBrazierBlockEntity.spawnPoofParticles(world, pos);
                        world.method_8396(null, pos, class_3417.field_26979, class_3419.field_15245, 1.0f, 1.0f);
                    }
                } else {
                    blockEntity.cancelRitual();
                }
            } else {
                blockEntity.cancelRitual();
            }
        }
    }

    public boolean startMoonRitual(class_1657 player) {
        if (this.method_5442()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.hexalia.moonlight_ritual.invalid_item"), true);
            return false;
        }
        class_1799 itemStack = this.method_5438(0);
        Optional recipe = Objects.requireNonNull(this.field_11863).method_8433().method_8132((class_3956)RitualBrazierRecipe.Type.INSTANCE, (class_1263)new class_1277(new class_1799[]{itemStack}), this.field_11863);
        if (recipe.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.hexalia.moonlight_ritual.invalid_item"), true);
            return false;
        }
        if (!RitualBrazierBlockEntity.isNight(this.field_11863, (class_2338)mutablePos)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.hexalia.moonlight_ritual.not_night"), true);
            return false;
        }
        this.timer = 1;
        this.setActive(true);
        player.method_7353((class_2561)class_2561.method_43471((String)"message.hexalia.moonlight_ritual.started"), true);
        return true;
    }

    public void cancelRitual() {
        this.timer = 0;
        this.setActive(false);
        this.method_5431();
    }

    private static void spawnPoofParticles(class_1937 world, class_2338 pos) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            double x = (double)pos.method_10263() + 0.5;
            double y = (double)pos.method_10264() + 1.0;
            double z = (double)pos.method_10260() + 0.5;
            serverWorld.method_14199((class_2394)class_2398.field_11203, x, y, z, 10, 0.2, 0.2, 0.2, 0.02);
        }
    }

    public void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            this.method_5431();
            if (this.field_11863 != null && !this.field_11863.field_9236) {
                this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    private static boolean isNight(class_1937 world, class_2338 pos) {
        boolean isTimeNight;
        class_2338.class_2339 mutablePos = new class_2338.class_2339(pos.method_10263(), pos.method_10264(), pos.method_10260());
        long time = world.method_8532() % 24000L;
        boolean bl = isTimeNight = time > 12500L && time < 23000L;
        if (world.method_8311(mutablePos.method_10084())) {
            return isTimeNight && world.method_8314(class_1944.field_9284, mutablePos.method_10084()) < 12;
        }
        return isTimeNight;
    }

    public int[] method_5494(class_2350 side) {
        return new int[]{0};
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return true;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }

    public int method_5439() {
        return 1;
    }

    public boolean method_5442() {
        return ((class_1799)this.inventory.get(0)).method_7960();
    }

    public class_1799 method_5438(int slot) {
        if (slot < 0 || slot >= this.inventory.size()) {
            return class_1799.field_8037;
        }
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 getRenderStack() {
        return this.method_5438(0);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 result = class_1262.method_5430(this.inventory, (int)slot, (int)amount);
        if (!result.method_7960()) {
            this.method_5431();
        }
        return result;
    }

    public class_1799 method_5441(int slot) {
        class_1799 result = class_1262.method_5428(this.inventory, (int)slot);
        if (!result.method_7960()) {
            this.method_5431();
        }
        return result;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public boolean method_5443(class_1657 player) {
        return this.field_11867.method_10262((class_2382)player.method_24515()) <= 16.0;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public int method_5444() {
        return 1;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.timer = nbt.method_10550("Timer");
        this.active = nbt.method_10577("Active");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("Timer", this.timer);
        nbt.method_10556("Active", this.active);
    }

    public class_2487 method_16887() {
        class_2487 nbt = super.method_16887();
        nbt.method_10556("Active", this.active);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        return nbt;
    }

    public boolean addStack(class_1799 itemStack) {
        if (this.method_5442() && !itemStack.method_7960()) {
            this.method_5447(0, itemStack.method_7971(1));
            this.method_5431();
            return true;
        }
        return false;
    }

    public class_1799 removeStack() {
        if (!this.method_5442()) {
            if (this.active) {
                this.cancelRitual();
            }
            class_1799 itemStack = this.method_5438(0).method_7972();
            this.method_5447(0, class_1799.field_8037);
            this.method_5431();
            return itemStack;
        }
        return class_1799.field_8037;
    }

    public void method_5431() {
        super.method_5431();
        if (!this.field_11863.method_8608()) {
            this.sync();
        }
    }

    private void sync() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_2540 data = PacketByteBufs.create();
            data.writeInt(this.inventory.size());
            for (class_1799 itemStack : this.inventory) {
                data.method_10793(itemStack);
            }
            data.method_10807(this.method_11016());
            for (class_3222 player : PlayerLookup.tracking((class_3218)serverWorld, (class_2338)this.method_11016())) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.SYNC_ITEM, (class_2540)data);
            }
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }
}

