/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.block.entity;

import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.grapes.hexalia.block.custom.RitualBrazierBlock;
import net.grapes.hexalia.block.entity.ImplementedInventory;
import net.grapes.hexalia.block.entity.ModBlockEntities;
import net.grapes.hexalia.block.entity.RitualBrazierBlockEntity;
import net.grapes.hexalia.networking.ModMessages;
import net.grapes.hexalia.recipe.TransmutationRecipe;
import net.grapes.hexalia.sound.ModSounds;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class RitualTableBlockEntity
extends class_2586
implements ImplementedInventory {
    private int progress = 0;
    private static final int MAX_PROGRESS = 120;
    private boolean ritualInProgress = false;
    private class_2371<class_1799> inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);

    public RitualTableBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.RITUAL_TABLE_BE, pos, state);
    }

    public boolean startRitual() {
        return this.performTransmutation(this.field_11863, this.field_11867);
    }

    public void cancelRitual() {
        this.ritualInProgress = false;
        this.progress = 0;
        this.method_5431();
    }

    public static void tick(class_3218 world, class_2338 pos, class_2680 state, RitualTableBlockEntity ritualTableBlockEntity) {
        if (ritualTableBlockEntity.ritualInProgress) {
            ++ritualTableBlockEntity.progress;
            if (ritualTableBlockEntity.progress >= 120) {
                ritualTableBlockEntity.completeRitual(world, pos);
            }
            ritualTableBlockEntity.method_5431();
        }
    }

    private void completeRitual(class_3218 world, class_2338 pos) {
        this.performRitualEffect(world, pos);
        this.cancelRitual();
    }

    private void performRitualEffect(class_3218 world, class_2338 pos) {
        world.method_14199((class_2394)class_2398.field_11215, (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5, 20, 0.5, 0.5, 0.5, 0.1);
        world.method_8396(null, pos, ModSounds.RITUAL_SUCCESS, class_3419.field_15245, 1.0f, 1.0f);
    }

    private void spawnParticleEffect(class_1937 world, class_2338 pos, class_2400 particleType, int minParticles, int maxParticles) {
        int particleCount = ThreadLocalRandom.current().nextInt(minParticles, maxParticles + 1);
        for (int i = 0; i < particleCount; ++i) {
            double offsetX = ThreadLocalRandom.current().nextDouble(-0.5, 0.5);
            double offsetY = ThreadLocalRandom.current().nextDouble(0.0, 0.5);
            double offsetZ = ThreadLocalRandom.current().nextDouble(-0.5, 0.5);
            world.method_8406((class_2394)particleType, (double)pos.method_10263() + 0.5 + offsetX, (double)pos.method_10264() + 1.0 + offsetY, (double)pos.method_10260() + 0.5 + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    public boolean canStartRitual(class_1937 world, class_2338 tablePos) {
        if (!this.isRitualReady(world, tablePos)) {
            return false;
        }
        class_1799 inputStack = this.method_5438(0);
        if (inputStack.method_7960()) {
            this.sendMessageToPlayer(world, tablePos, "message.hexalia.ritual.missing_ingredients");
            this.spawnParticleEffect(world, tablePos, class_2398.field_11251, 10, 20);
            return false;
        }
        Optional recipeOptional = world.method_8433().method_8132((class_3956)TransmutationRecipe.Type.INSTANCE, (class_1263)this, world);
        if (recipeOptional.isEmpty()) {
            this.sendMessageToPlayer(world, tablePos, "message.hexalia.ritual.missing_ingredients");
            this.spawnParticleEffect(world, tablePos, class_2398.field_11251, 10, 20);
            return false;
        }
        TransmutationRecipe recipe = (TransmutationRecipe)recipeOptional.get();
        boolean hasRequiredSalt = this.processSaltBlocks(world, tablePos, recipe, false);
        if (!hasRequiredSalt) {
            this.sendMessageToPlayer(world, tablePos, "message.hexalia.ritual.missing_ingredients");
            this.spawnParticleEffect(world, tablePos, class_2398.field_11251, 10, 20);
            return false;
        }
        return true;
    }

    private boolean isRitualReady(class_1937 world, class_2338 tablePos) {
        class_2338[] brazierPositions;
        for (class_2338 pos : brazierPositions = new class_2338[]{tablePos.method_10069(-2, 0, 0), tablePos.method_10069(2, 0, 0), tablePos.method_10069(0, 0, -2), tablePos.method_10069(0, 0, 2)}) {
            class_2680 blockState = world.method_8320(pos);
            if (!(blockState.method_26204() instanceof RitualBrazierBlock)) {
                this.sendMessageToPlayer(world, tablePos, "message.hexalia.ritual.missing_brazier");
                this.spawnParticleEffect(world, tablePos, class_2398.field_11251, 10, 20);
                return false;
            }
            if (((Boolean)blockState.method_11654((class_2769)RitualBrazierBlock.SALTED)).booleanValue()) continue;
            this.sendMessageToPlayer(world, tablePos, "message.hexalia.ritual.missing_salt");
            this.spawnParticleEffect(world, tablePos, class_2398.field_11251, 10, 20);
            return false;
        }
        boolean cropsValid = this.validateAndResetCrops(world, tablePos, false);
        if (!cropsValid) {
            this.sendMessageToPlayer(world, tablePos, "message.hexalia.ritual.invalid_crops");
            this.spawnParticleEffect(world, tablePos, class_2398.field_11251, 10, 20);
        }
        return cropsValid;
    }

    private boolean validateAndResetCrops(class_1937 world, class_2338 tablePos, boolean resetCrops) {
        class_2338[] cropPositions = new class_2338[]{tablePos.method_10069(-2, 0, -2), tablePos.method_10069(-1, 0, -2), tablePos.method_10069(1, 0, -2), tablePos.method_10069(2, 0, -2), tablePos.method_10069(-2, 0, -1), tablePos.method_10069(-1, 0, -1), tablePos.method_10069(1, 0, -1), tablePos.method_10069(2, 0, -1), tablePos.method_10069(-2, 0, 1), tablePos.method_10069(-1, 0, 1), tablePos.method_10069(1, 0, 1), tablePos.method_10069(2, 0, 1), tablePos.method_10069(-2, 0, 2), tablePos.method_10069(-1, 0, 2), tablePos.method_10069(1, 0, 2), tablePos.method_10069(2, 0, 2)};
        boolean allCropsValid = true;
        for (class_2338 pos : cropPositions) {
            class_2680 state = world.method_8320(pos);
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof class_2302) {
                class_2302 crop = (class_2302)class_22482;
                if (crop.method_9829(state) < crop.method_9827()) {
                    allCropsValid = false;
                    continue;
                }
                if (!resetCrops) continue;
                class_2680 resetState = crop.method_9828(0);
                world.method_8652(pos, resetState, 3);
                continue;
            }
            allCropsValid = false;
        }
        return allCropsValid;
    }

    public boolean processSaltBlocks(class_1937 world, class_2338 tablePos, TransmutationRecipe recipe, boolean consume) {
        class_2338[] brazierPositions;
        class_2371 requiredSaltItems = class_2371.method_10211();
        requiredSaltItems.addAll(recipe.getSaltItems());
        block0: for (class_2338 pos : brazierPositions = new class_2338[]{tablePos.method_10069(-2, 0, 0), tablePos.method_10069(2, 0, 0), tablePos.method_10069(0, 0, -2), tablePos.method_10069(0, 0, 2)}) {
            class_2586 blockEntity = world.method_8321(pos);
            if (!(blockEntity instanceof RitualBrazierBlockEntity)) continue;
            RitualBrazierBlockEntity brazier = (RitualBrazierBlockEntity)blockEntity;
            Iterator iterator = requiredSaltItems.iterator();
            while (iterator.hasNext()) {
                class_1799 item = (class_1799)iterator.next();
                if (!class_1799.method_7973((class_1799)brazier.method_5438(0), (class_1799)item)) continue;
                iterator.remove();
                if (!consume) continue block0;
                brazier.method_5441(0);
                brazier.method_5431();
                class_2680 brazierState = world.method_8320(pos);
                if (((Boolean)brazierState.method_11654((class_2769)RitualBrazierBlock.SALTED)).booleanValue()) {
                    world.method_8652(pos, (class_2680)brazierState.method_11657((class_2769)RitualBrazierBlock.SALTED, (Comparable)Boolean.valueOf(false)), 3);
                }
                world.method_8413(pos, world.method_8320(pos), world.method_8320(pos), 3);
                continue block0;
            }
        }
        return requiredSaltItems.isEmpty();
    }

    private void sendMessageToPlayer(class_1937 world, class_2338 pos, String messageKey) {
        class_1657 nearestPlayer;
        if (!world.field_9236 && (nearestPlayer = world.method_18459((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 5.0, false)) != null) {
            nearestPlayer.method_7353((class_2561)class_2561.method_43471((String)messageKey), true);
        }
    }

    public boolean performTransmutation(class_1937 world, class_2338 pos) {
        class_1277 inventory = new class_1277(this.method_5439());
        class_1799 inputStack = this.method_5438(0);
        if (!this.isRitualReady(world, pos)) {
            return false;
        }
        if (inputStack.method_7960()) {
            this.sendMessageToPlayer(world, pos, "message.hexalia.ritual.missing_ingredients");
            return false;
        }
        inventory.method_5447(0, inputStack);
        Optional recipeOptional = world.method_8433().method_8132((class_3956)TransmutationRecipe.Type.INSTANCE, (class_1263)this, world);
        if (recipeOptional.isEmpty()) {
            this.sendMessageToPlayer(world, pos, "message.hexalia.ritual.missing_ingredients");
            return false;
        }
        TransmutationRecipe recipe = (TransmutationRecipe)recipeOptional.get();
        boolean hasRequiredSalt = this.processSaltBlocks(world, pos, recipe, false);
        if (!hasRequiredSalt) {
            this.sendMessageToPlayer(world, pos, "message.hexalia.ritual.missing_ingredients");
            return false;
        }
        this.processSaltBlocks(world, pos, recipe, true);
        this.method_5434(0, 1);
        this.method_5447(0, recipe.method_8110(world.method_30349()).method_7972());
        this.method_5431();
        world.method_8413(pos, world.method_8320(pos), world.method_8320(pos), 3);
        this.validateAndResetCrops(world, pos, true);
        return true;
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.progress = nbt.method_10550("Progress");
        this.ritualInProgress = nbt.method_10577("RitualInProgress");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("Progress", this.progress);
        nbt.method_10556("RitualInProgress", this.ritualInProgress);
    }

    public int method_5444() {
        return 1;
    }

    @Override
    public void method_5431() {
        super.method_5431();
        if (!this.field_11863.method_8608()) {
            this.sync();
        }
    }

    private void sync() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_2540 data = PacketByteBufs.create();
            data.writeInt(this.inventory.size());
            for (class_1799 itemStack : this.inventory) {
                data.method_10793(itemStack);
            }
            data.method_10807(this.method_11016());
            for (class_3222 player : PlayerLookup.tracking((class_3218)serverWorld, (class_2338)this.method_11016())) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.SYNC_ITEM, (class_2540)data);
            }
        }
    }

    public class_1799 getRenderStack() {
        return this.method_5438(0);
    }

    public void setInventory(class_2371<class_1799> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.inventory.set(i, (Object)((class_1799)list.get(i)));
        }
        this.method_5431();
    }

    public boolean addItem(class_1799 itemStack) {
        if (this.method_5442() && !itemStack.method_7960()) {
            this.method_5447(0, itemStack.method_7971(1));
            this.method_5431();
            return true;
        }
        return false;
    }

    public class_1799 removeItem() {
        if (!this.method_5442()) {
            class_1799 itemStack = this.getStoredItem().method_7971(1);
            this.method_5431();
            return itemStack;
        }
        return class_1799.field_8037;
    }

    @Override
    public boolean method_5442() {
        return this.method_5438(0).method_7960();
    }

    public class_1799 getStoredItem() {
        return this.method_5438(0);
    }

    public class_2487 method_16887() {
        class_2487 nbtCompound = new class_2487();
        class_1262.method_5427((class_2487)nbtCompound, this.inventory, (boolean)true);
        return nbtCompound;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }
}

