/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.block.entity;

import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.grapes.hexalia.block.entity.HeatingBlockEntity;
import net.grapes.hexalia.block.entity.ImplementedInventory;
import net.grapes.hexalia.block.entity.ModBlockEntities;
import net.grapes.hexalia.item.ModItems;
import net.grapes.hexalia.recipe.SmallCauldronRecipe;
import net.grapes.hexalia.screen.SmallCauldronScreenHandler;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class SmallCauldronBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
ImplementedInventory,
HeatingBlockEntity {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)8, (Object)class_1799.field_8037);
    public static final int INPUT_SLOT_1 = 0;
    public static final int INPUT_SLOT_2 = 1;
    public static final int INPUT_SLOT_3 = 2;
    public static final int OUTPUT_SLOT = 6;
    public static final int BOTTLE_SLOT = 7;
    private int progress = 0;
    private int maxProgress = 175;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> SmallCauldronBlockEntity.this.progress;
                case 1 -> SmallCauldronBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    SmallCauldronBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    SmallCauldronBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public SmallCauldronBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.SMALL_CAULDRON_BE, pos, state);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Small Cauldron");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new SmallCauldronScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("small_cauldron.progress", this.progress);
    }

    public void method_11014(class_2487 nbt) {
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.progress = nbt.method_10550("small_cauldron.progress");
        super.method_11014(nbt);
    }

    public void brewingTick(class_1937 world, class_2338 pos, class_2680 state) {
        if (this.isHeated() && this.canInsertOutputSlot() && this.hasRecipe()) {
            this.increaseCraftingProgress();
            SmallCauldronBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private void craftItem() {
        this.getCurrentRecipe().ifPresent(recipe -> {
            this.method_5434(0, 1);
            this.method_5434(1, 1);
            this.method_5434(2, 1);
            this.method_5434(7, 1);
            class_1799 output = recipe.method_8110(null);
            this.method_5447(6, new class_1799((class_1935)output.method_7909(), this.method_5438(6).method_7947() + output.method_7947()));
        });
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private boolean hasRecipe() {
        return this.getCurrentRecipe().map(recipe -> {
            class_1799 output = recipe.method_8110(null);
            return this.canInsertAmountIntoOutputSlot(output.method_7947()) && this.canInsertItemIntoOutputSlot(output) && this.hasRequiredIngredients((SmallCauldronRecipe)recipe);
        }).orElse(false);
    }

    private boolean canInsertItemIntoOutputSlot(class_1799 output) {
        return this.method_5438(6).method_7960() || this.method_5438(6).method_7909() == output.method_7909();
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.method_5438(6).method_7914() >= this.method_5438(6).method_7947() + count;
    }

    private Optional<SmallCauldronRecipe> getCurrentRecipe() {
        class_1277 inventory = new class_1277(this.method_5439());
        for (int i = 0; i < this.method_5439(); ++i) {
            inventory.method_5447(i, this.method_5438(i));
        }
        return Objects.requireNonNull(this.method_10997()).method_8433().method_8132((class_3956)SmallCauldronRecipe.Type.INSTANCE, (class_1263)inventory, this.method_10997());
    }

    private boolean hasRequiredIngredients(SmallCauldronRecipe recipe) {
        boolean hasRusticBottle = recipe.getBottleSlot().method_8093(this.method_5438(7));
        if (!hasRusticBottle) {
            return false;
        }
        for (class_1856 ingredient : recipe.method_8117()) {
            boolean foundIngredient = false;
            for (int i = 0; i <= 2; ++i) {
                if (!ingredient.method_8093(this.method_5438(i))) continue;
                foundIngredient = true;
                break;
            }
            if (foundIngredient) continue;
            return false;
        }
        return true;
    }

    public boolean isHeated() {
        return this.field_11863 != null && this.isHeated(this.field_11863, this.field_11867);
    }

    private boolean canInsertOutputSlot() {
        return this.method_5438(6).method_7960() || this.method_5438(6).method_7947() < this.method_5438(6).method_7914();
    }

    public static class IngredientSlot
    extends class_1735 {
        public IngredientSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean method_7680(class_1799 stack) {
            return stack.method_7909() != ModItems.RUSTIC_BOTTLE;
        }
    }

    public static class RusticBottleSlot
    extends class_1735 {
        public RusticBottleSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public int method_7676(class_1799 stack) {
            return 64;
        }
    }
}

