/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.block.entity;

import java.util.List;
import net.grapes.hexalia.block.entity.ModBlockEntities;
import net.grapes.hexalia.sound.ModSounds;
import net.minecraft.class_1297;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;

public class WindsongBlockEntity
extends class_2586 {
    private int activeTicks = 0;
    private static final int DURATION = 600;
    private static final int AREA_RADIUS = 6;
    private int particleCooldown = 0;

    public WindsongBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.WINDSONG_BE, pos, state);
    }

    public void activate() {
        this.activeTicks = 600;
    }

    public boolean isActive() {
        return this.activeTicks > 0;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (this.isActive()) {
            --this.activeTicks;
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                class_238 area = new class_238(pos).method_1014(6.0);
                List projectiles = serverWorld.method_8390(class_1297.class, area, entity -> entity instanceof class_1676);
                for (class_1297 projectile : projectiles) {
                    if (projectile.method_31481()) continue;
                    WindsongBlockEntity.discardProjectile(serverWorld, projectile);
                }
                this.emitParticles(serverWorld, pos);
            }
            if (this.activeTicks <= 0) {
                world.method_8396(null, pos, ModSounds.WIND_BURST, class_3419.field_15245, 1.0f, 1.0f);
                world.method_22352(pos, false);
            }
        }
    }

    private static void discardProjectile(class_3218 world, class_1297 projectile) {
        world.method_43128(null, projectile.method_23317(), projectile.method_23318(), projectile.method_23321(), ModSounds.WIND_DEFLECT, class_3419.field_15245, 1.0f, 1.0f);
        class_243 pos = projectile.method_19538();
        for (int i = 0; i < 5; ++i) {
            double angle = Math.random() * 2.0 * Math.PI;
            double radius = Math.random() * 0.5;
            double x = pos.field_1352 + radius * Math.cos(angle);
            double z = pos.field_1350 + radius * Math.sin(angle);
            double y = pos.field_1351 + Math.random() * 0.5;
            world.method_14199((class_2394)class_2398.field_11245, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
        projectile.method_31472();
    }

    private void emitParticles(class_3218 world, class_2338 pos) {
        if (this.particleCooldown <= 0) {
            class_243 center = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
            for (int i = 0; i < 3; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double radius = Math.random() * 6.0;
                double x = center.field_1352 + radius * Math.cos(angle);
                double z = center.field_1350 + radius * Math.sin(angle);
                double y = center.field_1351 + Math.random() * 2.0;
                world.method_14199((class_2394)class_2398.field_11204, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
            }
            this.particleCooldown = 5;
        } else {
            --this.particleCooldown;
        }
    }
}

