/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.block.entity;

import net.grapes.hexalia.block.entity.ModBlockEntities;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4538;

public class LunarLilyBlockEntity
extends class_2586 {
    private static final int DURATION = 1200;
    private static final int BONEMEAL_INTERVAL = 240;
    private long activationTime = -1L;

    public LunarLilyBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.LUNAR_LILY_BE, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, LunarLilyBlockEntity entity) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (entity.isActive()) {
                long elapsedTime = world.method_8510() - entity.activationTime;
                if (!LunarLilyBlockEntity.isNight(world)) {
                    entity.deactivate();
                    return;
                }
                if (elapsedTime >= 1200L) {
                    entity.deactivate();
                    return;
                }
                if (elapsedTime % 240L == 0L) {
                    LunarLilyBlockEntity.applyBonemealToCropsAndSaplings(serverWorld, pos);
                }
                entity.method_5431();
            }
        }
    }

    private static void applyBonemealToCropsAndSaplings(class_3218 world, class_2338 centerPos) {
        class_2338.method_10097((class_2338)centerPos.method_10069(-4, -2, -4), (class_2338)centerPos.method_10069(4, 2, 4)).forEach(pos -> {
            class_2680 state = world.method_8320(pos);
            class_2248 patt0$temp = state.method_26204();
            if (patt0$temp instanceof class_2256) {
                class_2256 fertilizable = (class_2256)patt0$temp;
                if ((state.method_26164(class_3481.field_20341) || state.method_26164(class_3481.field_15462)) && fertilizable.method_9651((class_4538)world, pos, state, false)) {
                    fertilizable.method_9652(world, world.method_8409(), pos, state);
                    world.method_14199((class_2394)class_2398.field_11211, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 1, 0.2, 0.2, 0.2, 0.0);
                }
            }
        });
    }

    public boolean isActive() {
        return this.activationTime > 0L && this.field_11863 != null && this.field_11863.method_8510() >= this.activationTime;
    }

    public void activate(long gameTime) {
        this.activationTime = gameTime;
        this.method_5431();
    }

    public void deactivate() {
        this.activationTime = -1L;
        this.method_5431();
    }

    private static boolean isNight(class_1937 world) {
        long time = world.method_8532();
        return time > 13000L && time < 23000L;
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10544("activationTime", this.activationTime);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.activationTime = nbt.method_10537("activationTime");
    }
}

