/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.censer;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import net.grapes.hexalia.block.ModBlocks;
import net.grapes.hexalia.block.custom.WindsongBlock;
import net.grapes.hexalia.block.entity.CenserBlockEntity;
import net.grapes.hexalia.censer.HerbCombination;
import net.grapes.hexalia.item.ModItems;
import net.grapes.hexalia.sound.ModSounds;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2614;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_4140;
import net.minecraft.class_5354;
import net.minecraft.class_5575;

public class CenserEffectHandler {
    public static final int AREA_RADIUS = 16;
    public static final int EFFECT_DURATION = 7200;
    private static final Map<class_1937, Set<class_2338>> UNDEAD_VEIL_CACHE = new WeakHashMap<class_1937, Set<class_2338>>();
    public static final Map<HerbCombination, BiConsumer<class_1937, class_2338>> EFFECTS = Map.of(new HerbCombination(ModItems.SIREN_KELP, ModBlocks.SPIRIT_BLOOM.method_8389()), CenserEffectHandler::applyFireproofPresence, new HerbCombination(ModBlocks.GHOST_FERN.method_8389(), ModBlocks.SPIRIT_BLOOM.method_8389()), CenserEffectHandler::applyUndeadVeil, new HerbCombination(ModBlocks.GHOST_FERN.method_8389(), ModItems.SIREN_KELP), CenserEffectHandler::applyLivestockComfort, new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModBlocks.SPIRIT_BLOOM.method_8389()), CenserEffectHandler::applyAnvilHarmony, new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModItems.SIREN_KELP), CenserEffectHandler::applyFishersBoon, new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModBlocks.GHOST_FERN.method_8389()), CenserEffectHandler::applySuctionZone);
    private static final Map<class_2338, ActiveCenserEffect> ACTIVE_EFFECTS = new HashMap<class_2338, ActiveCenserEffect>();
    private static final Map<class_1937, Set<EffectArea>> ACTIVE_EFFECT_AREAS = new HashMap<class_1937, Set<EffectArea>>();

    public static void registerActiveEffect(class_1937 world, class_2338 pos, HerbCombination combo, int remainingTime) {
        if (world.method_8608()) {
            return;
        }
        ACTIVE_EFFECTS.put(pos, new ActiveCenserEffect(null, remainingTime, combo));
        CenserEffectHandler.applyEffects(world, pos, combo);
        EffectType effectType = CenserEffectHandler.getEffectTypeForCombination(combo);
        if (effectType != null) {
            CenserEffectHandler.registerEffectArea(world, pos, effectType, remainingTime);
        }
    }

    public static void removeActiveEffect(class_2338 pos) {
        ACTIVE_EFFECTS.remove(pos);
    }

    private static void registerEffectArea(class_1937 world, class_2338 pos, EffectType effectType, int duration) {
        ACTIVE_EFFECT_AREAS.computeIfAbsent(world, k -> new HashSet()).add(new EffectArea(pos, effectType, duration));
        if (effectType == EffectType.UNDEAD_VEIL) {
            UNDEAD_VEIL_CACHE.computeIfAbsent(world, k -> new HashSet()).add(pos.method_10062());
        }
    }

    public static void removeEffectArea(class_1937 world, class_2338 pos) {
        if (ACTIVE_EFFECT_AREAS.containsKey(world)) {
            ACTIVE_EFFECT_AREAS.get(world).removeIf(area -> area.getCenter().equals((Object)pos));
            if (UNDEAD_VEIL_CACHE.containsKey(world)) {
                UNDEAD_VEIL_CACHE.get(world).remove(pos);
            }
        }
    }

    public static void startEffect(class_1937 world, class_2338 pos, HerbCombination combo) {
        class_2586 class_25862;
        if (world.method_8608()) {
            return;
        }
        ACTIVE_EFFECTS.put(pos, new ActiveCenserEffect(null, 7200, combo));
        CenserEffectHandler.applyEffects(world, pos, combo);
        EffectType effectType = CenserEffectHandler.getEffectTypeForCombination(combo);
        if (effectType != null) {
            CenserEffectHandler.registerEffectArea(world, pos, effectType, 7200);
        }
        if ((class_25862 = world.method_8321(pos)) instanceof CenserBlockEntity) {
            CenserBlockEntity censer = (CenserBlockEntity)class_25862;
            censer.setActiveCombination(combo);
            censer.setBurnTime(7200);
        }
    }

    public static boolean isUndeadVeilActiveInArea(class_1937 world, class_2338 pos) {
        if (!(world instanceof class_3218)) {
            return false;
        }
        Set<class_2338> veilPositions = UNDEAD_VEIL_CACHE.get(world);
        if (veilPositions == null || veilPositions.isEmpty()) {
            return false;
        }
        double radiusSquared = 256.0;
        for (class_2338 center : veilPositions) {
            if (!(pos.method_10262((class_2382)center) <= radiusSquared)) continue;
            return true;
        }
        return false;
    }

    public static void updateEffects(class_1937 world) {
        Iterator<Map.Entry<class_2338, ActiveCenserEffect>> it = ACTIVE_EFFECTS.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<class_2338, ActiveCenserEffect> entry = it.next();
            class_2338 pos = entry.getKey();
            ActiveCenserEffect effect = entry.getValue();
            effect.decrementDuration();
            if (effect.isExpired()) {
                CenserEffectHandler.clearEffect(world, pos, effect.combo());
                it.remove();
                continue;
            }
            CenserEffectHandler.applyEffects(world, pos, effect.combo());
        }
        if (ACTIVE_EFFECT_AREAS.containsKey(world)) {
            Iterator<EffectArea> areaIt = ACTIVE_EFFECT_AREAS.get(world).iterator();
            while (areaIt.hasNext()) {
                EffectArea area = areaIt.next();
                area.decrementTicks();
                if (!area.isExpired()) continue;
                areaIt.remove();
            }
        }
    }

    private static void clearEffect(class_1937 world, class_2338 pos, HerbCombination combo) {
        class_238 area = new class_238(pos).method_1014(16.0);
        world.method_18023((class_5575)class_1299.field_6097, area, class_1301.field_6154).forEach(player -> {
            player.method_5752().remove("HexaliaAnvilHarmony");
            player.method_5752().remove("HexaliaFishersBoon");
        });
        CenserEffectHandler.removeEffectArea(world, pos);
    }

    public static void applyEffects(class_1937 world, class_2338 pos, HerbCombination combo) {
        if (world.method_8608()) {
            return;
        }
        EFFECTS.getOrDefault(combo, (l, p) -> {}).accept(world, pos);
    }

    private static void applyFireproofPresence(class_1937 world, class_2338 pos) {
        class_238 area = new class_238(pos).method_1014(16.0);
        List livingEntities = world.method_8390(class_1309.class, area, class_1301.field_6154);
        for (class_1309 entity : livingEntities) {
            entity.method_20803(0);
            entity.method_6092(new class_1293(class_1294.field_5918, 100, 0, false, false, true));
        }
    }

    private static void applyUndeadVeil(class_1937 world, class_2338 pos) {
        class_238 area = new class_238(pos).method_1014(16.0);
        world.method_8390(class_1308.class, area, e -> e instanceof class_1588 && e.method_5864().method_5891() == class_1311.field_6302).forEach(mob -> {
            mob.method_5980(null);
            mob.method_6015(null);
            if (mob instanceof class_5354) {
                class_5354 angerable = (class_5354)mob;
                angerable.method_29513(null);
                angerable.method_29514(0);
            }
            if (!mob.method_6059(class_1294.field_5912)) {
                mob.method_6092(new class_1293(class_1294.field_5912, 140, 0, false, false));
            }
            mob.method_16826(0);
            try {
                if (mob.method_18868() != null) {
                    mob.method_18868().method_18875(class_4140.field_22355);
                    mob.method_18868().method_18875(class_4140.field_22333);
                    mob.method_18868().method_18875(class_4140.field_25361);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private static void applyLivestockComfort(class_1937 world, class_2338 pos) {
        class_238 area = new class_238(pos).method_1014(16.0);
        world.method_8390(class_1296.class, area, class_1301.field_6154).forEach(passiveEntity -> {
            if (passiveEntity.method_5618() < 0) {
                passiveEntity.method_5620((int)((double)passiveEntity.method_5618() * 0.5), true);
            }
        });
    }

    private static void applyAnvilHarmony(class_1937 world, class_2338 pos) {
        world.method_18023((class_5575)class_1299.field_6097, new class_238(pos).method_1014(16.0), class_1301.field_6154).forEach(player -> {
            class_2487 nbt = player.method_5647(new class_2487());
            nbt.method_10556("HexaliaAnvilHarmony", true);
            player.method_5651(nbt);
        });
    }

    private static void applyFishersBoon(class_1937 world, class_2338 pos) {
        world.method_18023((class_5575)class_1299.field_6097, new class_238(pos).method_1014(16.0), class_1301.field_6154).forEach(player -> {
            class_2487 nbt = player.method_5647(new class_2487());
            nbt.method_10556("HexaliaFishersBoon", true);
            player.method_5651(nbt);
        });
    }

    private static void applySuctionZone(class_1937 world, class_2338 pos) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        class_238 area = new class_238(pos).method_1014(16.0);
        List items = world.method_18023(class_5575.method_31795(class_1542.class), area, class_1301.field_6154);
        if (items.isEmpty()) {
            return;
        }
        boolean hasWindsong = class_2338.method_20437((class_2338)pos.method_10069(-16, -16, -16), (class_2338)pos.method_10069(16, 16, 16)).anyMatch(blockPos -> world.method_8320(blockPos).method_26204() instanceof WindsongBlock);
        List<class_2614> hoppers = hasWindsong ? class_2338.method_20437((class_2338)class_2338.method_49637((double)area.field_1323, (double)area.field_1322, (double)area.field_1321), (class_2338)class_2338.method_49637((double)area.field_1320, (double)area.field_1325, (double)area.field_1324)).map(arg_0 -> ((class_1937)world).method_8321(arg_0)).filter(be -> be instanceof class_2614).map(be -> (class_2614)be).toList() : Collections.emptyList();
        for (class_1542 item : items) {
            class_1657 nearestPlayer;
            if (item.method_31481()) continue;
            boolean itemAbsorbed = false;
            if (!hoppers.isEmpty()) {
                for (class_2614 hopper : hoppers) {
                    class_1799 remaining = class_2614.method_11260(null, (class_1263)hopper, (class_1799)item.method_6983().method_7972(), null);
                    if (remaining.method_7960()) {
                        itemAbsorbed = true;
                        break;
                    }
                    if (remaining.method_7947() >= item.method_6983().method_7947()) continue;
                    item.method_6979(remaining);
                    CenserEffectHandler.playSuctionEffects(serverWorld, item.method_19538());
                }
            }
            if (!itemAbsorbed && (nearestPlayer = (class_1657)CenserEffectHandler.findNearestEntity(item.method_19538(), world.method_18023(class_5575.method_31795(class_1657.class), area, class_1301.field_6154))) != null) {
                item.method_5694(nearestPlayer);
            }
            if (!itemAbsorbed) continue;
            CenserEffectHandler.playSuctionEffects(serverWorld, item.method_19538());
            item.method_31472();
        }
    }

    private static void playSuctionEffects(class_3218 world, class_243 pos) {
        world.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, ModSounds.WIND_BURST, class_3419.field_15245, 0.7f, 0.9f + world.field_9229.method_43057() * 0.2f);
        for (int i = 0; i < 8; ++i) {
            double angle = world.field_9229.method_43058() * 2.0 * Math.PI;
            double radius = world.field_9229.method_43058() * 0.5;
            double x = pos.field_1352 + radius * Math.cos(angle);
            double z = pos.field_1350 + radius * Math.sin(angle);
            double y = pos.field_1351 + world.field_9229.method_43058() * 0.5;
            world.method_14199((class_2394)class_2398.field_11245, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private static <T extends class_1297> T findNearestEntity(class_243 position, List<T> entities) {
        class_1297 nearest = null;
        double closestDistance = Double.MAX_VALUE;
        for (class_1297 entity : entities) {
            double distance = position.method_1025(entity.method_19538());
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            nearest = entity;
        }
        return (T)nearest;
    }

    public static boolean isValidCombination(class_1792 item1, class_1792 item2) {
        HerbCombination combo = new HerbCombination(item1, item2);
        return EFFECTS.containsKey(combo);
    }

    public static void clearPlayerEffectsInRange(class_1937 world, class_2338 pos) {
        class_238 area = new class_238(pos).method_1014(16.0);
        world.method_18023((class_5575)class_1299.field_6097, area, class_1301.field_6154).forEach(player -> {
            class_2487 nbt = player.method_5647(new class_2487());
            nbt.method_10551("HexaliaAnvilHarmony");
            nbt.method_10551("HexaliaFishersBoon");
            player.method_5651(nbt);
        });
        CenserEffectHandler.removeEffectArea(world, pos);
    }

    public static boolean isEffectActiveInArea(class_1937 world, class_2338 pos, EffectType effectType) {
        if (!(world instanceof class_3218)) {
            return false;
        }
        Set<EffectArea> areas = ACTIVE_EFFECT_AREAS.get(world);
        if (areas == null || areas.isEmpty()) {
            return false;
        }
        for (EffectArea area : areas) {
            if (area.getEffectType() != effectType || !(pos.method_10262((class_2382)area.getCenter()) <= 256.0)) continue;
            return true;
        }
        return false;
    }

    private static EffectType getEffectTypeForCombination(HerbCombination combo) {
        Map<HerbCombination, EffectType> combinationToEffect = Map.of(new HerbCombination(ModItems.SIREN_KELP, ModBlocks.SPIRIT_BLOOM.method_8389()), EffectType.FIREPROOF_PRESENCE, new HerbCombination(ModBlocks.GHOST_FERN.method_8389(), ModBlocks.SPIRIT_BLOOM.method_8389()), EffectType.UNDEAD_VEIL, new HerbCombination(ModBlocks.GHOST_FERN.method_8389(), ModItems.SIREN_KELP), EffectType.LIVESTOCK_COMFORT, new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModBlocks.SPIRIT_BLOOM.method_8389()), EffectType.ANVIL_HARMONY, new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModItems.SIREN_KELP), EffectType.FISHERS_BOON, new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModBlocks.GHOST_FERN.method_8389()), EffectType.SUCTION_ZONE);
        return combinationToEffect.getOrDefault(combo, null);
    }

    public static String getMessageKeyForCombination(HerbCombination combo) {
        if (combo.equals(new HerbCombination(ModItems.SIREN_KELP, ModBlocks.SPIRIT_BLOOM.method_8389()))) {
            return "message.hexalia.censer.fireproof_presence";
        }
        if (combo.equals(new HerbCombination(ModBlocks.GHOST_FERN.method_8389(), ModBlocks.SPIRIT_BLOOM.method_8389()))) {
            return "message.hexalia.censer.undead_veil";
        }
        if (combo.equals(new HerbCombination(ModBlocks.GHOST_FERN.method_8389(), ModItems.SIREN_KELP))) {
            return "message.hexalia.censer.livestock_comfort";
        }
        if (combo.equals(new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModBlocks.SPIRIT_BLOOM.method_8389()))) {
            return "message.hexalia.censer.anvil_harmony";
        }
        if (combo.equals(new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModItems.SIREN_KELP))) {
            return "message.hexalia.censer.fishers_boon";
        }
        if (combo.equals(new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModBlocks.GHOST_FERN.method_8389()))) {
            return "message.hexalia.censer.suction_zone";
        }
        return "message.hexalia.censer.generic_effect";
    }

    private static class ActiveCenserEffect {
        private final EffectType type;
        private int duration;
        private final HerbCombination combo;

        public ActiveCenserEffect(EffectType type, int duration, HerbCombination combo) {
            this.type = type;
            this.duration = duration;
            this.combo = combo;
        }

        public void decrementDuration() {
            --this.duration;
        }

        public boolean isExpired() {
            return this.duration <= 0;
        }

        public HerbCombination combo() {
            return this.combo;
        }
    }

    public static enum EffectType {
        FIREPROOF_PRESENCE,
        UNDEAD_VEIL,
        LIVESTOCK_COMFORT,
        ANVIL_HARMONY,
        FISHERS_BOON,
        SUCTION_ZONE;

    }

    public static class EffectArea {
        private final class_2338 center;
        private final EffectType effectType;
        private int remainingTicks;

        public EffectArea(class_2338 center, EffectType effectType, int duration) {
            this.center = center;
            this.effectType = effectType;
            this.remainingTicks = duration;
        }

        public class_2338 getCenter() {
            return this.center;
        }

        public EffectType getEffectType() {
            return this.effectType;
        }

        public boolean containsPos(class_2338 pos) {
            return pos.method_19771((class_2382)this.center, 16.0);
        }

        public void decrementTicks() {
            --this.remainingTicks;
        }

        public boolean isExpired() {
            return this.remainingTicks <= 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EffectArea that = (EffectArea)o;
            return this.center.equals((Object)that.center) && this.effectType == that.effectType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.center, this.effectType});
        }
    }
}

