/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import net.astralya.hexalia.block.custom.CenserBlock;
import net.astralya.hexalia.block.custom.censer.CenserEffectHandler;
import net.astralya.hexalia.block.custom.censer.HerbCombination;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.block.entity.custom.SyncBlockEntity;
import net.minecraft.class_1262;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class CenserBlockEntity
extends SyncBlockEntity {
    private static final int SIZE = 2;
    private final class_2371<class_1799> items = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    private HerbCombination activeCombination = null;
    private int burnTime = 0;
    private static final int EFFECT_INTERVAL = 40;
    private boolean effectActive = false;

    public CenserBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.CENSER, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, CenserBlockEntity be) {
        if (!((Boolean)state.method_11654((class_2769)CenserBlock.LIT)).booleanValue()) {
            return;
        }
        if (be.burnTime > 0) {
            --be.burnTime;
            if (be.burnTime % 40 == 0 && be.activeCombination != null) {
                CenserEffectHandler.applyEffects(world, pos, be.activeCombination);
                if (!be.effectActive) {
                    CenserEffectHandler.registerActiveEffect(world, pos, be.activeCombination, be.burnTime);
                    be.effectActive = true;
                }
            }
            if (be.burnTime <= 0) {
                be.extinguish(world, pos, state);
            }
            be.inventoryChanged();
        }
    }

    private void extinguish(class_1937 world, class_2338 pos, class_2680 state) {
        if (this.activeCombination != null) {
            CenserEffectHandler.clearPlayerEffectsInRange(world, pos);
            CenserEffectHandler.removeActiveEffect(pos);
            this.activeCombination = null;
            this.effectActive = false;
        }
        world.method_8652(pos, (class_2680)state.method_11657((class_2769)CenserBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
        world.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 1.0f);
        this.inventoryChanged();
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public class_1799 getStack(int slot) {
        if (slot < 0 || slot >= 2) {
            return class_1799.field_8037;
        }
        return (class_1799)this.items.get(slot);
    }

    public void setStack(int slot, class_1799 stack) {
        if (slot < 0 || slot >= 2) {
            return;
        }
        this.items.set(slot, (Object)stack);
        this.inventoryChanged();
    }

    public void clearInventory() {
        for (int i = 0; i < 2; ++i) {
            this.items.set(i, (Object)class_1799.field_8037);
        }
        this.inventoryChanged();
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public void setActiveCombination(HerbCombination combo) {
        this.activeCombination = combo;
        this.inventoryChanged();
    }

    public HerbCombination getActiveCombination() {
        return this.activeCombination;
    }

    public void setBurnTime(int time) {
        this.burnTime = time;
        this.inventoryChanged();
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.items);
        for (class_1799 stack : this.items) {
            if (stack.method_7960() || stack.method_7947() > 0 && stack.method_7947() <= stack.method_7914()) continue;
            stack.method_7939(1);
        }
        if (nbt.method_10545("ActiveCombination")) {
            class_2487 comboTag = nbt.method_10562("ActiveCombination");
            class_1792 item1 = class_1792.method_7875((int)comboTag.method_10550("Item1"));
            class_1792 item2 = class_1792.method_7875((int)comboTag.method_10550("Item2"));
            this.activeCombination = new HerbCombination(item1, item2);
        }
        this.burnTime = nbt.method_10550("BurnTime");
        this.effectActive = nbt.method_10577("EffectActive");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.items);
        nbt.method_10569("BurnTime", this.burnTime);
        nbt.method_10556("EffectActive", this.effectActive);
        if (this.activeCombination != null) {
            class_2487 comboTag = new class_2487();
            comboTag.method_10569("Item1", class_1792.method_7880((class_1792)this.activeCombination.item1()));
            comboTag.method_10569("Item2", class_1792.method_7880((class_1792)this.activeCombination.item2()));
            nbt.method_10566("ActiveCombination", (class_2520)comboTag);
        }
    }

    @Override
    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public boolean isEmpty() {
        for (class_1799 stack : this.items) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 removeStack(int slot) {
        if (slot < 0 || slot >= 2) {
            return class_1799.field_8037;
        }
        class_1799 stack = ((class_1799)this.items.get(slot)).method_7972();
        this.items.set(slot, (Object)class_1799.field_8037);
        this.inventoryChanged();
        return stack;
    }
}

