/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.astralya.hexalia.recipe.ModRecipes;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2371;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class RitualTableRecipeBuilder
implements class_5797 {
    private final class_2371<class_1856> ingredients = class_2371.method_10211();
    private final class_1799 output;
    private final class_1792 resultItem;
    private final class_161.class_162 advancement = class_161.class_162.method_707();

    private RitualTableRecipeBuilder(class_1799 output) {
        this.output = output.method_7972();
        this.resultItem = this.output.method_7909();
    }

    public static RitualTableRecipeBuilder ritual(class_1935 result, int count) {
        return new RitualTableRecipeBuilder(new class_1799(result, count));
    }

    public static RitualTableRecipeBuilder ritual(class_1799 output) {
        return new RitualTableRecipeBuilder(output);
    }

    public RitualTableRecipeBuilder tableItem(class_1935 item) {
        return this.addIngredient(class_1856.method_8091((class_1935[])new class_1935[]{item}));
    }

    public RitualTableRecipeBuilder brazierItem(class_1935 item) {
        return this.addIngredient(class_1856.method_8091((class_1935[])new class_1935[]{item}));
    }

    public RitualTableRecipeBuilder addIngredient(class_1856 ingredient) {
        this.ingredients.add((Object)ingredient);
        return this;
    }

    public RitualTableRecipeBuilder addIngredient(class_1935 item) {
        return this.addIngredient(class_1856.method_8091((class_1935[])new class_1935[]{item}));
    }

    public RitualTableRecipeBuilder addIngredient(class_1799 stack) {
        return this.addIngredient(class_1856.method_8101((class_1799[])new class_1799[]{stack}));
    }

    public RitualTableRecipeBuilder criterion(String name, class_184 conditions) {
        this.advancement.method_709(name, conditions);
        return this;
    }

    public RitualTableRecipeBuilder group(@Nullable String group) {
        return this;
    }

    public class_1792 method_36441() {
        return this.resultItem;
    }

    public void method_17972(Consumer<class_2444> exporter, class_2960 recipeId) {
        if (this.ingredients.isEmpty()) {
            throw new IllegalStateException("Ritual Table recipe must have at least 1 ingredient (table item).");
        }
        if (this.ingredients.size() > 5) {
            throw new IllegalStateException("Too many ingredients for Ritual Table recipe (max 5: 1 table + 4 braziers).");
        }
        this.advancement.method_708(new class_2960("recipes/root")).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)recipeId)).method_703(class_170.class_171.method_753((class_2960)recipeId));
        class_2960 advId = new class_2960(recipeId.method_12836(), "recipes/ritual_table/" + recipeId.method_12832());
        exporter.accept(new JsonBuilder(recipeId, this.output, this.ingredients, this.advancement, advId));
    }

    public static class JsonBuilder
    implements class_2444 {
        private final class_2960 id;
        private final class_1799 output;
        private final class_2371<class_1856> ingredients;
        private final class_161.class_162 advancement;
        private final class_2960 advancementId;

        public JsonBuilder(class_2960 id, class_1799 output, class_2371<class_1856> ingredients, class_161.class_162 advancement, class_2960 advancementId) {
            this.id = id;
            this.output = output.method_7972();
            this.ingredients = ingredients;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void method_10416(JsonObject json) {
            json.addProperty("type", "hexalia:ritual_table");
            JsonArray ing = new JsonArray();
            for (class_1856 i : this.ingredients) {
                ing.add(i.method_8089());
            }
            json.add("ingredients", (JsonElement)ing);
            JsonObject out = new JsonObject();
            out.addProperty("item", class_7923.field_41178.method_10221((Object)this.output.method_7909()).toString());
            if (this.output.method_7947() > 1) {
                out.addProperty("count", (Number)this.output.method_7947());
            }
            json.add("output", (JsonElement)out);
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return ModRecipes.RITUAL_TABLE_SERIALIZER;
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancement.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

