/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.util;

import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;

public class TeleportUtil {
    public static boolean canReturn(class_1937 world, class_1657 player, boolean allowInterdimensional) {
        if (world.field_9236) {
            return false;
        }
        class_5321 spawnDim = ((class_3222)player).method_26281();
        return world.method_27983() != spawnDim && !allowInterdimensional;
    }

    public static void teleportPlayerToSpawn(class_1937 currentWorld, class_1657 player, boolean allowInterdimensional) {
        class_243 pos;
        class_2338 spawnPoint;
        if (currentWorld.field_9236 || TeleportUtil.canReturn(currentWorld, player, allowInterdimensional)) {
            return;
        }
        class_3218 targetWorld = TeleportUtil.getTargetWorld(currentWorld, player);
        player.method_5848();
        if (player.method_6113()) {
            player.method_18400();
        }
        if (targetWorld != null && (spawnPoint = TeleportUtil.getSpawnPointPosition(player, targetWorld)) != null && (pos = TeleportUtil.findRespawnPosition(targetWorld, spawnPoint, player)) != null) {
            TeleportUtil.doReturn(player, currentWorld, targetWorld, pos.field_1352, pos.field_1351, pos.field_1350);
        }
    }

    private static class_3218 getTargetWorld(class_1937 currentWorld, class_1657 player) {
        class_5321 spawnPointDimension = ((class_3222)player).method_26281();
        return currentWorld.method_27983() == spawnPointDimension ? (class_3218)currentWorld : Objects.requireNonNull(currentWorld.method_8503()).method_3847(spawnPointDimension);
    }

    private static class_2338 getSpawnPointPosition(class_1657 player, class_3218 world) {
        return player instanceof class_3222 ? ((class_3222)player).method_26280() : null;
    }

    private static class_243 findRespawnPosition(class_3218 world, class_2338 spawnPoint, class_1657 player) {
        return class_1657.method_26091((class_3218)world, (class_2338)spawnPoint, (float)((class_3222)player).method_30631(), (boolean)false, (boolean)true).orElse(null);
    }

    private static void doReturn(class_1657 player, class_1937 origin, class_3218 target, double x, double y, double z) {
        TeleportUtil.playTeleportSound(player, target, x, y, z);
        if (origin != target) {
            TeleportUtil.addChunkTicket(target, x, y, z, player.method_5628());
            ((class_3222)player).method_14251(target, x, y, z, player.method_36454(), player.method_36455());
        } else {
            player.method_5859(x, y, z);
        }
        if (player.field_6017 > 0.0f) {
            player.field_6017 = 0.0f;
        }
        TeleportUtil.playTeleportSound(player, target, x, y, z);
    }

    private static void playTeleportSound(class_1657 player, class_3218 world, double x, double y, double z) {
        world.method_43128(null, x, y, z, class_3417.field_14890, class_3419.field_15248, 1.0f, 1.0f);
    }

    private static void addChunkTicket(class_3218 world, double x, double y, double z, int playerId) {
        world.method_14178().method_17297(class_3230.field_19347, new class_1923(new class_2338((int)x, (int)y, (int)z)), 1, (Object)playerId);
    }
}

