/*
 * Decompiled with CFR 0.152.
 */
package net.kurasava.smoothnight.config;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ModConfig {
    public double modifier = 0.1;
    public static long maxStep = 2400L;
    public boolean doSkipWeather = true;
    private static final File configFile = new File("config/smooth-night.json");

    public ModConfig() {
        this.loadConfig();
    }

    private static JSONObject readConfig() {
        if (configFile.exists()) {
            JSONObject jSONObject;
            FileReader reader = new FileReader(configFile.getAbsolutePath());
            try {
                JSONTokener tokener = new JSONTokener(reader);
                jSONObject = new JSONObject(tokener);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            reader.close();
            return jSONObject;
        }
        return null;
    }

    public void loadConfig() {
        JSONObject jsonObject = ModConfig.readConfig();
        if (jsonObject != null) {
            this.modifier = jsonObject.getDouble("modifier");
            this.doSkipWeather = jsonObject.getBoolean("skip_weather");
        }
    }

    public void saveConfig() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("modifier", this.modifier);
        jsonObject.put("skip_weather", this.doSkipWeather);
        try (FileWriter file = new FileWriter(configFile);){
            file.write(jsonObject.toString(4));
            file.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

