/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.common.block.entity;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.generatorgalore.Config;
import cy.jdkdigital.generatorgalore.cap.ControlledEnergyStorage;
import cy.jdkdigital.generatorgalore.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.generatorgalore.common.container.GeneratorMenu;
import cy.jdkdigital.generatorgalore.common.container.ManualItemHandler;
import cy.jdkdigital.generatorgalore.init.ModTags;
import cy.jdkdigital.generatorgalore.util.GeneratorCreator;
import cy.jdkdigital.generatorgalore.util.GeneratorObject;
import cy.jdkdigital.generatorgalore.util.GeneratorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratorBlockEntity
extends CapabilityBlockEntity {
    private int tickCounter = 0;
    public int litTime;
    public int litDuration;
    public double remainder = 0.0;
    public int fluidId = 0;
    public final GeneratorObject generator;
    private final LazyOptional<ControlledEnergyStorage> energyHandler;
    private final LazyOptional<IItemHandlerModifiable> inventoryHandler;
    private final LazyOptional<IFluidHandler> fluidInventory;
    private List<IEnergyStorage> recipients = new ArrayList<IEnergyStorage>();
    private boolean hasLoaded = false;
    private double fluidConsumeLeftover;

    public GeneratorBlockEntity(final GeneratorObject generator, BlockPos blockPos, BlockState blockState) {
        super(generator.getBlockEntityType().get(), blockPos, blockState);
        this.generator = generator;
        this.energyHandler = LazyOptional.of(() -> new ControlledEnergyStorage(generator.getBufferCapacity()));
        this.inventoryHandler = LazyOptional.of(() -> new ManualItemHandler(2){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 1) {
                    return stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
                }
                if (!generator.getFuelTag().equals((Object)GeneratorUtil.EMPTY_TAG)) {
                    return stack.m_204117_(ModTags.getItemTag(generator.getFuelTag()));
                }
                if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FOOD)) {
                    return stack.m_41720_().getFoodProperties(stack, null) != null;
                }
                if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.ENCHANTMENT)) {
                    return EnchantmentHelper.m_44831_((ItemStack)stack).size() > 0;
                }
                if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.POTION)) {
                    return stack.m_41720_() instanceof PotionItem;
                }
                if (generator.getFuelList() != null) {
                    return generator.getFuelList().containsKey(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()));
                }
                return ForgeHooks.getBurnTime((ItemStack)stack, null) > 0;
            }

            protected void onContentsChanged(int slot) {
                GeneratorBlockEntity.this.m_6596_();
            }
        });
        this.fluidInventory = LazyOptional.of(() -> new FluidTank(10000){

            public boolean isFluidValid(FluidStack stack) {
                if (!generator.getFuelTag().equals((Object)GeneratorUtil.EMPTY_TAG)) {
                    return stack.getFluid().m_205067_(ModTags.getFluidTag(generator.getFuelTag()));
                }
                return super.isFluidValid(stack);
            }

            protected void onContentsChanged() {
                super.onContentsChanged();
                if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID)) {
                    GeneratorBlockEntity.this.fluidId = BuiltInRegistries.f_257020_.m_7447_((Object)this.getFluid().getFluid());
                    GeneratorBlockEntity.this.m_6596_();
                }
            }
        });
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GeneratorBlockEntity blockEntity) {
        int tickRate = (Integer)Config.SERVER.tickRate.get();
        if (!blockEntity.hasLoaded) {
            blockEntity.refreshConnectedTileEntityCache();
            blockEntity.hasLoaded = true;
        }
        if (++blockEntity.tickCounter % tickRate == 0) {
            blockEntity.energyHandler.ifPresent(energyHandler -> {
                double inputPowerAmount = blockEntity.generator.getGenerationRate() * (double)tickRate;
                AtomicBoolean hasConsumedFuel = new AtomicBoolean(false);
                if (!blockEntity.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID)) {
                    blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
                        if (blockEntity.isLit()) {
                            blockEntity.litTime = Math.max(0, blockEntity.litTime - tickRate);
                        }
                        ItemStack fuelStack = itemHandler.getStackInSlot(0);
                        if (!blockEntity.isLit() && !fuelStack.m_41619_() && itemHandler.isItemValid(0, fuelStack) && energyHandler.getEnergyStored() < energyHandler.getMaxEnergyStored()) {
                            boolean shouldBurn;
                            GeneratorCreator.Fuel fuel;
                            Object rate = new Pair((Object)Float.valueOf((float)blockEntity.generator.getGenerationRate()), (Object)blockEntity.litTime);
                            rate = blockEntity.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.ENCHANTMENT) ? GeneratorUtil.calculateEnchantmentGenerationRate(blockEntity.generator, fuelStack) : (blockEntity.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.POTION) ? GeneratorUtil.calculatePotionGenerationRate(blockEntity.generator, fuelStack) : (blockEntity.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FOOD) ? GeneratorUtil.calculateFoodGenerationRate(blockEntity.generator, fuelStack) : (blockEntity.generator.getFuelList() != null ? new Pair((Object)Float.valueOf((fuel = blockEntity.generator.getFuelList().get(ForgeRegistries.ITEMS.getKey((Object)fuelStack.m_41720_()))).rate() > 0.0f ? fuel.rate() : (float)blockEntity.generator.getOriginalGenerationRate()), (Object)fuel.burnTime()) : new Pair((Object)Float.valueOf((float)blockEntity.generator.getGenerationRate()), (Object)((int)((double)ForgeHooks.getBurnTime((ItemStack)fuelStack, null) * blockEntity.generator.getConsumptionRate()))))));
                            boolean bl = shouldBurn = energyHandler.getEnergyStored() < energyHandler.getMaxEnergyStored() / 2 || ((Float)rate.getFirst()).floatValue() * (float)((Integer)rate.getSecond()).intValue() <= (float)(energyHandler.getMaxEnergyStored() - energyHandler.getEnergyStored());
                            if (shouldBurn) {
                                blockEntity.generator.setGenerationRate(((Float)rate.getFirst()).floatValue());
                                blockEntity.litTime = (Integer)rate.getSecond();
                                if (blockEntity.litTime == 0) {
                                    blockEntity.litTime = (int)blockEntity.generator.getConsumptionRate();
                                }
                                blockEntity.litDuration = blockEntity.litTime;
                                if (blockEntity.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.ENCHANTMENT) && itemHandler instanceof ItemStackHandler) {
                                    ItemStackHandler stackHandler = (ItemStackHandler)itemHandler;
                                    stackHandler.setStackInSlot(0, new ItemStack((ItemLike)(fuelStack.m_41720_() instanceof EnchantedBookItem ? Items.f_42517_ : fuelStack.m_41720_())));
                                } else if (!fuelStack.getCraftingRemainingItem().m_41619_() && fuelStack.m_41613_() == 1 && itemHandler instanceof ItemStackHandler) {
                                    ItemStackHandler stackHandler = (ItemStackHandler)itemHandler;
                                    stackHandler.setStackInSlot(0, fuelStack.getCraftingRemainingItem());
                                } else {
                                    fuelStack.m_41774_(1);
                                }
                            }
                        }
                        if (blockEntity.isLit()) {
                            hasConsumedFuel.set(true);
                        }
                    });
                } else if (blockEntity.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID) && (double)energyHandler.getEnergyStored() + inputPowerAmount <= (double)energyHandler.getMaxEnergyStored()) {
                    blockEntity.fluidInventory.ifPresent(fluidHandler -> blockEntity.energyHandler.ifPresent(handler -> {
                        double fluidConsumeAmount = blockEntity.generator.getConsumptionRate() * (double)tickRate + blockEntity.fluidConsumeLeftover;
                        if (fluidHandler.getFluidInTank(0).getAmount() >= (int)fluidConsumeAmount) {
                            blockEntity.fluidConsumeLeftover = fluidConsumeAmount - (double)((int)fluidConsumeAmount);
                            fluidHandler.drain((int)fluidConsumeAmount, IFluidHandler.FluidAction.EXECUTE);
                            hasConsumedFuel.set(true);
                        }
                    }));
                }
                if (hasConsumedFuel.get()) {
                    inputPowerAmount = blockEntity.generator.getGenerationRate() * (double)tickRate;
                    int addedPower = (int)(inputPowerAmount += blockEntity.remainder);
                    blockEntity.remainder = inputPowerAmount - (double)addedPower;
                    energyHandler.receiveEnergy(addedPower, false, true);
                    blockEntity.setOn(true);
                } else {
                    blockEntity.setOn(false);
                }
            });
            blockEntity.sendOutPower((int)blockEntity.generator.getTransferRate() * tickRate);
            blockEntity.m_6596_();
        }
    }

    public boolean isLit() {
        return this.litTime > 0;
    }

    private void setOn(boolean isOn) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(isOn)));
        }
    }

    private void sendOutPower(int amount) {
        if (this.f_58857_ != null) {
            this.energyHandler.ifPresent(energyHandler -> {
                AtomicInteger capacity = new AtomicInteger(energyHandler.getEnergyStored());
                if (capacity.get() > 0) {
                    AtomicBoolean dirty = new AtomicBoolean(false);
                    if (this.generator.hasChargeSlot()) {
                        this.inventoryHandler.ifPresent(h -> {
                            ItemStack chargeItem = h.getStackInSlot(1);
                            if (!chargeItem.m_41619_()) {
                                chargeItem.getCapability(ForgeCapabilities.ENERGY).ifPresent(chargeItemHandler -> {
                                    int received = chargeItemHandler.receiveEnergy(Math.min(capacity.get(), amount), false);
                                    capacity.addAndGet(-received);
                                    energyHandler.extractEnergy(received, false);
                                    dirty.set(true);
                                });
                            }
                        });
                    }
                    for (IEnergyStorage handler : this.recipients) {
                        boolean doContinue;
                        boolean bl = doContinue = capacity.get() > 0;
                        if (handler.canReceive() && doContinue) {
                            int received = handler.receiveEnergy(Math.min(capacity.get(), amount), false);
                            capacity.addAndGet(-received);
                            energyHandler.extractEnergy(received, false);
                            dirty.set(true);
                        }
                        if (doContinue) continue;
                        break;
                    }
                    if (dirty.get()) {
                        this.m_6596_();
                    }
                }
            });
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new GeneratorMenu(id, inventory, this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryHandler.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && this.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID)) {
            return this.fluidInventory.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void refreshConnectedTileEntityCache() {
        if (this.f_58857_ instanceof ServerLevel) {
            Direction[] directions;
            ArrayList<IEnergyStorage> recipients = new ArrayList<IEnergyStorage>();
            for (Direction direction : directions = Direction.values()) {
                BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
                if (te == null) continue;
                te.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).ifPresent(recipients::add);
            }
            this.recipients = recipients;
        }
    }

    @NotNull
    public Component m_7755_() {
        return Component.m_237115_((String)("block.generatorgalore." + this.generator.getId().m_135815_().toLowerCase(Locale.ENGLISH) + "_generator"));
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.litTime = tag.m_128451_("litTime");
        this.litDuration = tag.m_128451_("litDuration");
        if (tag.m_128441_("generationRate")) {
            this.generator.setGenerationRate(tag.m_128459_("generationRate"));
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("litTime", this.litTime);
        tag.m_128405_("litDuration", this.litDuration);
        if (this.generator.getGenerationRate() != this.generator.getOriginalGenerationRate()) {
            tag.m_128347_("generationRate", this.generator.getGenerationRate());
        }
    }

    @Override
    public void loadPacketNBT(CompoundTag tag) {
        super.loadPacketNBT(tag);
        if (this.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID)) {
            Fluid fluid = this.fluidInventory.map(fluidHandler -> fluidHandler.getFluidInTank(0).getFluid()).orElse(Fluids.f_76191_);
            this.fluidId = BuiltInRegistries.f_257020_.m_7447_((Object)fluid);
        }
    }
}

