/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.generatorgalore.GeneratorGalore;
import cy.jdkdigital.generatorgalore.init.ModRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record SolidFuelRecipe(ResourceLocation id, List<Ingredient> fuels, Ingredient generator, float rate, int burnTime) implements Recipe<Container>
{
    public boolean m_5818_(Container pContainer, Level pLevel) {
        return false;
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess registryAccess) {
        return null;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return null;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.SOLID_FUEL.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.SOLID_FUEL_TYPE.get();
    }

    public static class Serializer<T extends SolidFuelRecipe>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromJson(ResourceLocation id, JsonObject json) {
            Ingredient generator = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"generator"));
            float rate = GsonHelper.m_13915_((JsonObject)json, (String)"rate");
            int burnTime = GsonHelper.m_13927_((JsonObject)json, (String)"consumptionRate");
            return this.factory.create(id, new ArrayList<Ingredient>(), generator, rate, burnTime);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                ArrayList<Ingredient> fuels = new ArrayList<Ingredient>();
                IntStream.range(0, buffer.readInt()).forEach(i -> fuels.add(Ingredient.m_43940_((FriendlyByteBuf)buffer)));
                return this.factory.create(id, fuels, Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.readFloat(), buffer.readInt());
            }
            catch (Exception e) {
                GeneratorGalore.LOGGER.error("Error reading solid fuels recipe from packet. " + String.valueOf(id), (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                buffer.writeInt(((SolidFuelRecipe)recipe).fuels().size());
                ((SolidFuelRecipe)recipe).fuels().forEach(fuel -> fuel.m_43923_(buffer));
                ((SolidFuelRecipe)recipe).generator().m_43923_(buffer);
                buffer.writeFloat(((SolidFuelRecipe)recipe).rate());
                buffer.writeInt(((SolidFuelRecipe)recipe).burnTime());
            }
            catch (Exception e) {
                GeneratorGalore.LOGGER.error("Error writing solid fuels recipe to packet. " + String.valueOf(((SolidFuelRecipe)recipe).m_6423_()), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends SolidFuelRecipe> {
            public T create(ResourceLocation var1, List<Ingredient> var2, Ingredient var3, float var4, int var5);
        }
    }
}

