/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import cy.jdkdigital.generatorgalore.GeneratorGalore;
import cy.jdkdigital.generatorgalore.common.block.Generator;
import cy.jdkdigital.generatorgalore.common.block.entity.GeneratorBlockEntity;
import cy.jdkdigital.generatorgalore.common.container.GeneratorMenu;
import cy.jdkdigital.generatorgalore.common.item.UpgradeItem;
import cy.jdkdigital.generatorgalore.init.ModBlockEntityTypes;
import cy.jdkdigital.generatorgalore.init.ModContainerTypes;
import cy.jdkdigital.generatorgalore.util.GeneratorObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class GeneratorCreator {
    public static GeneratorObject create(ResourceLocation id, JsonObject json) throws JsonSyntaxException {
        Optional generatorOptional = GeneratorObject.codec(id).parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result();
        if (generatorOptional.isPresent()) {
            GeneratorObject generator = (GeneratorObject)generatorOptional.get();
            String name = String.format("%s_%s", generator.getId().m_135815_(), "generator");
            generator.setBlockSupplier((Supplier<Block>)GeneratorGalore.BLOCKS.register(name, () -> new Generator(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50094_), generator)));
            generator.setBlockEntityType(ModBlockEntityTypes.register(name, () -> ModBlockEntityTypes.createBlockEntityType((pos, state) -> new GeneratorBlockEntity(generator, pos, state), generator.getBlockSupplier().get())));
            generator.setMenuType(ModContainerTypes.register(name, GeneratorMenu::new));
            GeneratorGalore.ITEMS.register(name, () -> new BlockItem(generator.getBlockSupplier().get(), new Item.Properties()));
            if (json.has("previousTier")) {
                String previousTier = json.get("previousTier").getAsString();
                GeneratorGalore.ITEMS.register(previousTier + "_to_" + generator.getId().m_135815_() + "_upgrade", () -> new UpgradeItem(new Item.Properties(), previousTier, generator));
            }
            if (json.has("fuelList")) {
                generator.setFuelList(GeneratorCreator.parseFuelList(generator, json.get("fuelList")));
            }
            return generator;
        }
        GeneratorGalore.LOGGER.info("failed to read generator configuration for " + String.valueOf(id));
        return null;
    }

    private static Map<ResourceLocation, Fuel> parseFuelList(GeneratorObject generator, JsonElement fuelList) {
        HashMap<ResourceLocation, Fuel> fuels = new HashMap<ResourceLocation, Fuel>();
        for (JsonElement jsonElement : fuelList.getAsJsonArray()) {
            JsonObject el = jsonElement.getAsJsonObject();
            ResourceLocation id = new ResourceLocation(el.get("item").getAsString());
            fuels.put(id, new Fuel(el.has("rate") ? el.get("rate").getAsFloat() : (float)generator.getGenerationRate(), el.get("burnTime").getAsInt()));
        }
        return fuels;
    }

    public record Fuel(float rate, int burnTime) {
    }
}

