/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.dillon.speedrunnermod.main.SpeedrunnerModClient;
import net.dillon.speedrunnermod.util.AI;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@AI
@Environment(value=EnvType.CLIENT)
public class ClientSyncedServerOptions {
    private static final Map<UUID, List<String>> TRANSLATIONS = new HashMap<UUID, List<String>>();

    public static void setLastSentTutorialModeMessageTranslations(UUID playerUuid, List<String> translations) {
        TRANSLATIONS.put(playerUuid, translations);
        SpeedrunnerModClient.clientOptions().storedValues.lastCompletedTutorialStepMessageTranslations.set(ClientSyncedServerOptions.getLastSentTutorialModeMessageTranslations(playerUuid));
        SpeedrunnerModClient.saveClientChanges();
    }

    public static List<String> getLastSentTutorialModeMessageTranslations(UUID playerUuid) {
        return TRANSLATIONS.getOrDefault(playerUuid, SpeedrunnerModClient.clientOptions().storedValues.lastCompletedTutorialStepMessageTranslations.getCurrentValue());
    }

    public static boolean tutorialModeMessageTranslationsContainsPlayerUuid(UUID playerUuid) {
        return TRANSLATIONS.containsKey(playerUuid);
    }

    public static void writeAndClearTutorialModeMessageTranslations(UUID playerUuid) {
        SpeedrunnerModClient.clientOptions().storedValues.lastCompletedTutorialStepMessageTranslations.set(ClientSyncedServerOptions.getLastSentTutorialModeMessageTranslations(playerUuid));
        SpeedrunnerModClient.saveClientChanges();
        TRANSLATIONS.remove(playerUuid);
    }
}

