/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.client.render;

import net.dillon.speedrunnermod.block.ModBlocks;
import net.dillon.speedrunnermod.block.sign.TerraformSignBlockHelper;
import net.dillon.speedrunnermod.entity.ModEntityTypes;
import net.dillon.speedrunnermod.main.SpeedrunnerMod;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_10255;
import net.minecraft.class_11515;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_881;

@Environment(value=EnvType.CLIENT)
public class ModRenderers {
    private static void initializeBlockRenderers() {
        BlockRenderLayerMap.putBlock((class_2248)ModBlocks.SPEEDRUNNER_SAPLING, (class_11515)class_11515.field_60925);
        BlockRenderLayerMap.putBlock((class_2248)ModBlocks.DEAD_SPEEDRUNNER_SAPLING, (class_11515)class_11515.field_60925);
        BlockRenderLayerMap.putBlock((class_2248)ModBlocks.SPEEDRUNNER_LEAVES, (class_11515)class_11515.field_60925);
        BlockRenderLayerMap.putBlock((class_2248)ModBlocks.DEAD_SPEEDRUNNER_LEAVES, (class_11515)class_11515.field_60925);
        BlockRenderLayerMap.putBlock((class_2248)ModBlocks.DOOM_LEAVES, (class_11515)class_11515.field_60925);
        BlockRenderLayerMap.putBlock((class_2248)ModBlocks.WOODEN_SPEEDRUNNER_DOOR, (class_11515)class_11515.field_60925);
        BlockRenderLayerMap.putBlock((class_2248)ModBlocks.DEAD_WOODEN_SPEEDRUNNER_DOOR, (class_11515)class_11515.field_60925);
        BlockRenderLayerMap.putBlock((class_2248)ModBlocks.SPEEDRUNNER_DOOR, (class_11515)class_11515.field_60925);
        BlockRenderLayerMap.putBlock((class_2248)ModBlocks.WOODEN_SPEEDRUNNER_TRAPDOOR, (class_11515)class_11515.field_60925);
        BlockRenderLayerMap.putBlock((class_2248)ModBlocks.DEAD_WOODEN_SPEEDRUNNER_TRAPDOOR, (class_11515)class_11515.field_60925);
        BlockRenderLayerMap.putBlock((class_2248)ModBlocks.SPEEDRUNNER_TRAPDOOR, (class_11515)class_11515.field_60925);
        BlockRenderLayerMap.putBlock((class_2248)ModBlocks.DEAD_SPEEDRUNNER_BUSH, (class_11515)class_11515.field_60925);
        SpeedrunnerMod.debug("Initialized custom block models.");
    }

    private static void initializeOtherRenderers() {
        ModRenderers.registerBoatRenderer(ModEntityTypes.SPEEDRUNNER_BOAT, ModRenderers.boatModelLayer("speedrunner"), false);
        ModRenderers.registerBoatRenderer(ModEntityTypes.SPEEDRUNNER_CHEST_BOAT, ModRenderers.chestBoatModelLayer("speedrunner"), true);
        ModRenderers.registerBoatRenderer(ModEntityTypes.DEAD_SPEEDRUNNER_BOAT, ModRenderers.boatModelLayer("dead_speedrunner"), false);
        ModRenderers.registerBoatRenderer(ModEntityTypes.DEAD_SPEEDRUNNER_CHEST_BOAT, ModRenderers.chestBoatModelLayer("dead_speedrunner"), true);
        ModRenderers.registerBoatRenderer(ModEntityTypes.CRIMSON_BOAT, ModRenderers.boatModelLayer("crimson"), false);
        ModRenderers.registerBoatRenderer(ModEntityTypes.CRIMSON_CHEST_BOAT, ModRenderers.chestBoatModelLayer("crimson"), true);
        ModRenderers.registerBoatRenderer(ModEntityTypes.WARPED_BOAT, ModRenderers.boatModelLayer("warped"), false);
        ModRenderers.registerBoatRenderer(ModEntityTypes.WARPED_CHEST_BOAT, ModRenderers.chestBoatModelLayer("warped"), true);
        TerraformSignBlockHelper.registerDefaultWoodType(SpeedrunnerMod.ofSpeedrunnerMod("speedrunner"));
        SpeedrunnerMod.debug("Initialized custom renderers.");
    }

    private static <T extends class_10255> void registerBoatRenderer(class_1299<? extends T> entityType, class_5601 modelLayer, boolean chest) {
        ModRenderers.registerEntityRenderer(entityType, modelLayer, chest ? class_554::method_62066 : class_554::method_31985, context -> new class_881(context, modelLayer));
    }

    private static <T extends class_1297> void registerEntityRenderer(class_1299<? extends T> entityType, class_5601 modelLayer, EntityModelLayerRegistry.TexturedModelDataProvider texturedModelDataProvider, class_5617<T> entityRendererFactory) {
        EntityModelLayerRegistry.registerModelLayer((class_5601)modelLayer, (EntityModelLayerRegistry.TexturedModelDataProvider)texturedModelDataProvider);
        EntityRendererRegistry.register(entityType, entityRendererFactory);
    }

    private static class_5601 boatModelLayer(String id) {
        return new class_5601(SpeedrunnerMod.ofSpeedrunnerMod("boat/" + id), "main");
    }

    private static class_5601 chestBoatModelLayer(String id) {
        return new class_5601(SpeedrunnerMod.ofSpeedrunnerMod("chest_boat/" + id), "main");
    }

    public static void initializeRenderers() {
        ModRenderers.initializeBlockRenderers();
        ModRenderers.initializeOtherRenderers();
    }
}

