/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.client.screen.base;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.dillon.speedrunnermod.client.screen.CustomButtonListWidget;
import net.dillon.speedrunnermod.client.screen.base.BaseModScreen;
import net.dillon.speedrunnermod.client.screen.base.leaderboard.LeaderboardsIneligibleScreen;
import net.dillon.speedrunnermod.client.screen.base.option.ResetOptionsConfirmScreen;
import net.dillon.speedrunnermod.client.screen.base.option.RestartRequiredScreen;
import net.dillon.speedrunnermod.client.screen.base.synced.MatchSettingsWithServerScreen;
import net.dillon.speedrunnermod.client.screen.feature.AbstractFeatureScreen;
import net.dillon.speedrunnermod.client.screen.feature.ScreenCategory;
import net.dillon.speedrunnermod.client.screen.options.AdvancedOptionsScreen;
import net.dillon.speedrunnermod.client.screen.options.FastWorldCreationOptionsScreen;
import net.dillon.speedrunnermod.main.SpeedrunnerMod;
import net.dillon.speedrunnermod.main.SpeedrunnerModClient;
import net.dillon.speedrunnermod.option.Leaderboards;
import net.dillon.speedrunnermod.packet.ClientModPackets;
import net.dillon.speedrunnermod.util.AI;
import net.dillon.speedrunnermod.util.ModTexts;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_353;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_5244;
import net.minecraft.class_7172;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractModScreen
extends BaseModScreen {
    protected boolean alreadySettingToIneligibleScreen = false;
    protected File configFile;
    protected final File configDirectory = new File(FabricLoader.getInstance().getConfigDir().toUri());
    protected final class_437 parent;
    protected class_4185 helpButton;
    protected class_4185 saveButton;
    protected class_4185 openOptionsFileButton;
    protected class_4185 openOptionsDirectoryButton;
    protected class_4185 doneButton;
    protected class_4185 matchSettingsWithServer;
    public class_4185 resetOptionsButton;
    public class_353 optionList;
    protected CustomButtonListWidget buttonList;
    protected final List<class_339> featureButtons = new ArrayList<class_339>();

    public AbstractModScreen(class_437 parent, class_2561 title) {
        super(parent, title);
        this.parent = parent;
    }

    protected void method_25426() {
        if (this.isOptionsScreen()) {
            this.optionList = (class_353)this.method_37063((class_364)new class_353(this.field_22787, this.field_22789, (class_4667)this));
            this.saveButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)ModTexts.SAVE, button -> this.method_25419()).method_46434(this.getButtonsLeftSide(), this.getDoneButtonHeight(), 100, 20).method_46431());
            this.openOptionsFileButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)ModTexts.MENU_OPEN_OPTIONS_FILE, button -> {
                this.method_25419();
                this.configFile = !AbstractModScreen.method_25442() ? SpeedrunnerMod.configHandler().getConfigFile() : SpeedrunnerModClient.clientConfigHandler().getConfigFile();
                class_156.method_668().method_672(this.configFile);
            }).method_46434(this.getButtonsMiddle(), this.getDoneButtonHeight(), 100, 20).method_46431());
            this.resetOptionsButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)ModTexts.RESET, button -> this.field_22787.method_1507((class_437)new ResetOptionsConfirmScreen(this.parent, false))).method_46434(this.getButtonsRightSide(), this.getDoneButtonHeight(), 100, 20).method_46431());
            this.helpButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)ModTexts.BLANK, button -> this.openLink("https://modrinth.com/mod/speedrunner-mod", true)).method_46434(this.getButtonsRightSide() + 104, this.getDoneButtonHeight(), 20, 20).method_46431());
            this.openOptionsDirectoryButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"D."), button -> class_156.method_668().method_672(this.configDirectory)).method_46434(this.getButtonsRightSide() + 128, this.getDoneButtonHeight(), 20, 20).method_46431());
            this.matchSettingsWithServer = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)ModTexts.BLANK, button -> this.field_22787.method_1507((class_437)new MatchSettingsWithServerScreen(this.parent))).method_46434(this.getButtonsLeftSide() - 24, this.getDoneButtonHeight(), 20, 20).method_46431());
            this.matchSettingsWithServer.field_22763 = this.isOnServer();
        } else {
            AbstractFeatureScreen featureScreen;
            AbstractModScreen abstractModScreen;
            if (!this.buttons().isEmpty()) {
                this.initializeCustomButtonListWidget();
                this.buttonList.addAll(this.buttons());
                this.method_25429((class_364)this.buttonList);
            }
            if ((abstractModScreen = this) instanceof AbstractFeatureScreen && (featureScreen = (AbstractFeatureScreen)abstractModScreen).getScreenCategory() != ScreenCategory.FIRST_TIME_PLAYING && featureScreen.getScreenCategory() != ScreenCategory.SECRET_DOOM_MODE || !(this instanceof AbstractFeatureScreen)) {
                this.doneButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)this.getDoneText(), button -> this.method_25419()).method_46434(this.field_22789 / 2 - 100, this.getDoneButtonHeight(), 200, 20).method_46431());
            }
        }
        if (this.hasSearchField()) {
            this.searchField = new class_342(this.field_22793, this.field_22789 / 2 + 15, 10, 90, 15, null);
            this.searchField.method_1880(50);
            this.searchField.method_47404((class_2561)class_2561.method_43471((String)(this.isOptionsScreen() ? "speedrunnermod.search_field_options_screen.placeholder" : "speedrunnermod.search_field_features_screen.placeholder")).method_27692(class_124.field_1056).method_27692(class_124.field_1080));
            this.method_25429((class_364)this.searchField);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.renderCustomText(context);
        if (this.shouldRenderVersionText()) {
            int leftSide = this.field_22789 / 2 - 155;
            int rightSide = leftSide + 160;
            int farRightSide = rightSide + 267;
            int height = this.field_22790 - 24;
            context.method_25300(this.field_22793, "Version: v1.11.8", farRightSide, height, -1);
        }
        if (this.searchField != null) {
            this.searchField.method_25394(context, mouseX, mouseY, delta);
            this.search(!this.searchField.method_1882().isEmpty());
        }
        this.lockOptionsAndRenderTooltips(context, mouseX, mouseY);
        if (this.shouldRenderTitleText()) {
            context.method_27534(this.field_22793, this.field_22785, this.hasSearchField() ? this.field_22789 / 2 - 45 : this.field_22789 / 2, 13, -1);
        }
        if (this.isOptionsScreen()) {
            context.method_25290(class_10799.field_56883, SpeedrunnerMod.ofSpeedrunnerMod("textures/gui/question_mark.png"), this.helpButton.method_46426() + 2, this.helpButton.method_46427() + 2, 0.0f, 0.0f, 16, 16, 16, 16);
            context.method_25290(class_10799.field_56883, SpeedrunnerMod.ofSpeedrunnerMod("textures/gui/sync.png"), this.matchSettingsWithServer.method_46426() + 2, this.matchSettingsWithServer.method_46427() + 2, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        if (this.shouldRenderSpeedrunnerModTitle()) {
            int middle = this.field_22789 / 2 - 69;
            int height = 10;
            context.method_25290(class_10799.field_56883, class_2960.method_60654((String)"speedrunnermod:textures/gui/speedrunner_mod.png"), middle, height, 0.0f, 0.0f, 129, 16, 129, 16);
        }
        this.renderCustomObjects(context);
        if (!this.buttons().isEmpty() || this.shouldRenderTooltips()) {
            this.renderTooltips(context, mouseX, mouseY);
        }
    }

    protected void renderTooltips(class_332 context, int mouseX, int mouseY) {
        if (this.isOptionsScreen()) {
            if (this.saveButton.method_49606()) {
                this.renderBasicTooltip(ModTexts.SAVE_TOOLTIP, context, mouseX, mouseY);
            }
            if (this.openOptionsFileButton.method_49606()) {
                if (!AbstractModScreen.method_25442()) {
                    this.renderBasicTooltip(ModTexts.OPEN_OPTIONS_FILE_TOOLTIP, context, mouseX, mouseY);
                } else {
                    this.renderBasicTooltip(ModTexts.OPEN_CLIENT_OPTIONS_FILE_TOOLTIP, context, mouseX, mouseY);
                }
            }
            if (this.helpButton.method_49606()) {
                this.renderBasicTooltip(ModTexts.HELP_TOOLTIP, context, mouseX, mouseY);
            }
            if (this.openOptionsDirectoryButton.method_49606()) {
                this.renderBasicTooltip(ModTexts.DIRECTORY_TOOLTIP, context, mouseX, mouseY);
            }
            if (this.matchSettingsWithServer.method_49606()) {
                if (this.matchSettingsWithServer.field_22763) {
                    this.renderBasicTooltip((class_2561)class_2561.method_43471((String)"speedrunnermod.match_settings_with_server.tooltip"), context, mouseX, mouseY);
                } else {
                    this.renderBasicTooltip((class_2561)class_2561.method_43471((String)"speedrunnermod.match_settings_with_server.must_be_on_server.tooltip"), context, mouseX, mouseY);
                }
            }
        }
    }

    private void search(boolean lock) {
        if (this.buttonList != null) {
            for (CustomButtonListWidget.ModWidgetEntry entry : this.buttonList.method_25396()) {
                for (class_339 widget : entry.widgets) {
                    this.filter(widget, lock);
                }
            }
        } else {
            for (class_353.class_354 entry : this.optionList.method_25396()) {
                for (class_339 widget : entry.field_18214) {
                    this.filter(widget, lock);
                }
            }
        }
    }

    private void filter(class_339 widget, boolean lock) {
        String optionText = widget.method_25369().getString().toLowerCase();
        int colonIndex = optionText.indexOf(":");
        if (colonIndex > 0) {
            optionText = optionText.substring(0, optionText.indexOf(":")).toLowerCase();
        }
        widget.field_22763 = !lock || this.searchField.method_1882().isEmpty() || optionText.contains(this.searchField.method_1882().toLowerCase());
    }

    protected void lockOptionWithTooltip(class_7172<?> option, boolean bl, class_2561 defaultTooltip, class_2561 disabledTooltip) throws NullPointerException {
        block8: {
            try {
                if (this.optionList != null) {
                    if (this.getSimpleOption(option) == null) {
                        SpeedrunnerMod.error("No widget found with option: " + option.toString());
                    } else {
                        class_339 widget = this.getSimpleOption(option);
                        if (this.searchField.method_1882().isEmpty()) {
                            widget.field_22763 = bl;
                        } else {
                            widget.field_22763 = widget.method_25369().getString().toLowerCase().contains(this.searchField.method_1882().toLowerCase());
                            if (widget.method_49606() && !bl) {
                                widget.field_22763 = false;
                            }
                        }
                        this.getSimpleOption(option).method_47400(class_7919.method_47407((class_2561)(bl ? defaultTooltip : disabledTooltip)));
                    }
                    break block8;
                }
                throw new NullPointerException("\"optionList\" variable cannot be null on \"lockOption\" call.");
            }
            catch (NullPointerException n) {
                this.field_22787.method_1592();
                n.printStackTrace();
            }
        }
    }

    private class_339 getSimpleOption(class_7172<?> option) {
        for (class_353.class_354 entry : this.optionList.method_25396()) {
            for (class_339 widget : entry.field_18214) {
                String messageText = widget.method_25369().getString();
                if (!(messageText = messageText.substring(0, messageText.indexOf(":"))).equals(option.toString())) continue;
                return widget;
            }
        }
        return null;
    }

    protected void setParentAndResize() {
        if (this.parent != null) {
            this.parent.method_25410(this.field_22787, this.field_22789, this.field_22790);
            this.field_22787.method_1507(this.parent);
        } else {
            super.method_25419();
        }
    }

    @AI
    protected void addButtonsIteratively(ScreenCategory screenCategory) {
        this.featureButtons.clear();
        int maxPageNumber = SpeedrunnerModClient.ALL_FEATURE_SCREENS.stream().map(constructor -> (AbstractFeatureScreen)((Object)((Object)constructor.apply(this.parent)))).filter(screen -> screen.getScreenCategory() == screenCategory).mapToInt(AbstractFeatureScreen::getPageNumber).max().orElse(0);
        for (int pageNum = 1; pageNum <= maxPageNumber; ++pageNum) {
            for (Function<class_437, AbstractFeatureScreen> featureScreenConstructor : SpeedrunnerModClient.ALL_FEATURE_SCREENS) {
                AbstractFeatureScreen screen2 = featureScreenConstructor.apply(this.parent);
                if (screen2.getScreenCategory() != screenCategory || screen2.getPageNumber() != pageNum) continue;
                this.featureButtons.add((class_339)class_4185.method_46430((class_2561)AbstractModScreen.featureTitleText(screenCategory, screen2.linesKey()), button -> this.field_22787.method_1507((class_437)screen2)).method_46431());
            }
        }
    }

    public void method_25419() {
        if (this.isOptionsScreen()) {
            boolean bl2;
            SpeedrunnerModClient.saveAllChanges();
            boolean bl = this.field_22787.method_1576() != null;
            boolean bl3 = bl2 = this.field_22787.field_1687 != null;
            if (bl || bl2) {
                ClientModPackets.sendNewC2SOptions();
                if (bl2 && this instanceof FastWorldCreationOptionsScreen) {
                    ClientModPackets.syncFwc(this.field_22787, 0);
                }
            }
            LeaderboardsIneligibleScreen.needsRestart = false;
            LeaderboardsIneligibleScreen.needsRestartFromEnablingLeaderboardsMode = false;
            this.alreadySettingToIneligibleScreen = false;
            if (SpeedrunnerMod.options().main.leaderboardsMode.getCurrentValue().booleanValue()) {
                if (Leaderboards.wasLeaderboardsModeChanged()) {
                    LeaderboardsIneligibleScreen.needsRestartFromEnablingLeaderboardsMode = true;
                }
                if (LeaderboardsIneligibleScreen.needsRestartFromEnablingLeaderboardsMode) {
                    this.field_22787.method_1507((class_437)new LeaderboardsIneligibleScreen(this.parent));
                } else if (!Leaderboards.isEligibleForLeaderboardRuns()) {
                    if (RestartRequiredScreen.needsRestart()) {
                        LeaderboardsIneligibleScreen.needsRestart = true;
                    }
                    this.alreadySettingToIneligibleScreen = true;
                    this.field_22787.method_1507((class_437)new LeaderboardsIneligibleScreen(this.parent));
                } else if (!this.alreadySettingToIneligibleScreen && Leaderboards.wasLeaderboardsModeChanged() || RestartRequiredScreen.needsRestart()) {
                    this.field_22787.method_1507((class_437)new RestartRequiredScreen(this.parent));
                } else {
                    this.setParentAndResize();
                }
            } else if (RestartRequiredScreen.needsRestart()) {
                this.field_22787.method_1507((class_437)new RestartRequiredScreen(this.parent));
            } else {
                this.setParentAndResize();
            }
        } else {
            if (this.field_51824 != null) {
                this.field_51824.method_59869();
            }
            this.setParentAndResize();
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        AbstractModScreen abstractModScreen;
        if (this.isOptionsScreen() && (abstractModScreen = this) instanceof AdvancedOptionsScreen) {
            AdvancedOptionsScreen advancedOptionsScreen = (AdvancedOptionsScreen)abstractModScreen;
            if (!this.searchField.method_25370() && (this.hasADown() || this.hasXDown() || this.hasYDown() || this.hasZDown())) {
                double scrollY = advancedOptionsScreen.optionList.method_44387();
                this.refreshScreen(this.pageId());
                AdvancedOptionsScreen modScreen = (AdvancedOptionsScreen)class_310.method_1551().field_1755;
                modScreen.optionList.method_44382(scrollY);
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void initializeCustomButtonListWidget() {
        this.buttonList = (CustomButtonListWidget)this.method_37063((class_364)new CustomButtonListWidget(this.field_22787, this.field_22789, this));
    }

    protected List<class_339> buttons() {
        return !this.featureButtons.isEmpty() ? this.featureButtons : List.of();
    }

    private static class_2561 featureTitleText(ScreenCategory category, String lang) {
        return class_2561.method_43471((String)("speedrunnermod.title.features." + category.toString().toLowerCase() + "." + lang));
    }

    public boolean isOnServer() {
        return !this.field_22787.method_1542() && this.field_22787.method_1558() != null;
    }

    protected int getButtonsLeftSide() {
        return this.columns() == 3 ? this.field_22789 / 2 - 50 - 105 : (this.columns() == 2 ? this.field_22789 / 2 - 155 : this.field_22789 / 2 - 160);
    }

    protected int getButtonsMiddle() {
        return this.columns() == 2 ? this.field_22789 / 2 - 100 : this.field_22789 / 2 - 50;
    }

    protected int getButtonsRightSide() {
        return this.columns() == 3 ? this.field_22789 / 2 - 50 + 105 : (this.columns() == 2 ? this.getButtonsLeftSide() + 160 : this.field_22789 / 2 + 60);
    }

    protected int getButtonsHeight() {
        return this.field_22790 / 6 - 12;
    }

    protected int getCustomButtonsHeight() {
        return this.field_22790 / 6 + 126;
    }

    protected int getDoneButtonHeight() {
        return this.field_22790 - 29;
    }

    protected class_2561 getDoneText() {
        return class_5244.field_24334;
    }

    protected boolean shouldRenderTooltips() {
        return this.isOptionsScreen();
    }

    protected boolean hasADown() {
        return class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)65);
    }

    protected boolean hasXDown() {
        return class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)88);
    }

    protected boolean hasYDown() {
        return class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)89);
    }

    protected boolean hasZDown() {
        return class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)90);
    }

    protected boolean shouldRenderSpeedrunnerModTitle() {
        return false;
    }

    protected boolean hasSearchField() {
        return this.isOptionsScreen();
    }

    protected void renderCustomText(class_332 context) {
    }

    protected void renderCustomObjects(class_332 context) {
    }

    protected void lockOptionsAndRenderTooltips(class_332 context, int mouseX, int mouseY) {
    }

    public abstract String pageId();

    protected abstract int columns();

    protected abstract boolean shouldRenderVersionText();

    public abstract boolean isOptionsScreen();

    protected abstract boolean shouldRenderTitleText();
}

