/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.client.screen.base;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.dillon.speedrunnermod.client.screen.base.AbstractModScreen;
import net.dillon.speedrunnermod.main.SpeedrunnerMod;
import net.dillon.speedrunnermod.util.AI;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractScrollableScreen
extends AbstractModScreen {
    protected final class_437 parent;
    public final List<LineObject> objectsToDisplay = new ArrayList<LineObject>();
    private final int scrollSpeed = 12;
    protected float scrollOffset;
    protected float targetScrollOffset;
    private static final float SCROLL_LERP_SPEED = 0.2f;
    private boolean isDraggingScrollbar = false;
    private boolean isDraggingAnywhere = false;
    private int lastMouseY = -1;
    private int top;
    private int bottom;

    public AbstractScrollableScreen(class_437 parent, class_2561 title) {
        super(parent, title);
        this.parent = parent;
    }

    @AI
    private void loadAndPrintText(class_2960 path) {
        try (BufferedReader reader = new BufferedReader(this.field_22787.method_1478().openAsReader(path));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.trim().isEmpty()) {
                    this.objectsToDisplay.add(new LineObject((class_2561)class_2561.method_43470((String)" "), 1.0f, null, 0, 0, null));
                    continue;
                }
                this.objectsToDisplay.add(this.parseLine(line));
            }
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                SpeedrunnerMod.warn("No text file found for " + ((Object)((Object)this)).getClass().getSimpleName() + ": " + String.valueOf(path));
            }
            e.printStackTrace();
        }
    }

    @AI
    private LineObject parseLine(String line) {
        int headingLevel;
        if (line.startsWith("!image:")) {
            String imageLine = line.substring("!image:".length()).trim();
            float customScale = -1.0f;
            String[] parts = imageLine.split("\\s+");
            String imagePath = parts[0];
            for (int i = 1; i < parts.length; ++i) {
                if (!parts[i].startsWith("scale=")) continue;
                try {
                    customScale = Float.parseFloat(parts[i].substring("scale=".length()));
                    continue;
                }
                catch (NumberFormatException e) {
                    SpeedrunnerMod.error("Invalid scale format in line: " + line);
                }
            }
            class_2960 imageId = SpeedrunnerMod.ofSpeedrunnerMod(imagePath);
            try {
                class_1011 image = class_1011.method_4309((InputStream)this.field_22787.method_1478().open(imageId));
                int originalWidth = image.method_4307();
                int originalHeight = image.method_4323();
                float scale = customScale > 0.0f ? Math.min(customScale, 1.0f) : Math.min(1.0f, 300.0f / (float)originalWidth);
                int scaledWidth = (int)((float)originalWidth * scale);
                int scaledHeight = (int)((float)originalHeight * scale);
                return new LineObject(null, 1.0f, imageId, scaledWidth, scaledHeight, null);
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) {
                    SpeedrunnerMod.error("No image file found in referencing text file " + ((Object)((Object)this)).getClass().getSimpleName() + ": " + String.valueOf(imageId));
                } else {
                    e.printStackTrace();
                }
                return new LineObject((class_2561)class_2561.method_43470((String)"[Image Load Failed]"), 1.0f, null, 0, 0, null);
            }
        }
        for (headingLevel = 0; headingLevel < line.length() && line.charAt(headingLevel) == '#'; ++headingLevel) {
        }
        float scale = switch (headingLevel) {
            case 1 -> 2.0f;
            case 2 -> 1.5f;
            case 3 -> 1.3f;
            case 4 -> 1.1f;
            case 5 -> 0.9f;
            default -> 1.0f;
        };
        String content = line.substring(headingLevel).stripLeading();
        class_2561 formatted = this.parseLegacyFormattedText(content);
        return new LineObject(formatted, scale, null, 0, 0, null);
    }

    @AI
    private class_2561 parseLegacyFormattedText(String input) {
        class_2583 currentStyle = class_2583.field_24360;
        class_5250 result = class_2561.method_43470((String)"");
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c == '\u00a7' && i + 1 < input.length()) {
                currentStyle = this.applyFormatCode(currentStyle, input.charAt(i + 1));
                i += 2;
                continue;
            }
            result.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(c)).method_10862(currentStyle));
            ++i;
        }
        return result;
    }

    @AI
    private class_2583 applyFormatCode(class_2583 style, char code) {
        return switch (code) {
            case '0' -> style.method_10977(class_124.field_1074);
            case '1' -> style.method_10977(class_124.field_1058);
            case '2' -> style.method_10977(class_124.field_1077);
            case '3' -> style.method_10977(class_124.field_1062);
            case '4' -> style.method_10977(class_124.field_1079);
            case '5' -> style.method_10977(class_124.field_1064);
            case '6' -> style.method_10977(class_124.field_1065);
            case '7' -> style.method_10977(class_124.field_1080);
            case '8' -> style.method_10977(class_124.field_1063);
            case '9' -> style.method_10977(class_124.field_1078);
            case 'a' -> style.method_10977(class_124.field_1060);
            case 'b' -> style.method_10977(class_124.field_1075);
            case 'c' -> style.method_10977(class_124.field_1061);
            case 'd' -> style.method_10977(class_124.field_1076);
            case 'e' -> style.method_10977(class_124.field_1054);
            case 'f' -> style.method_10977(class_124.field_1068);
            case 'l' -> style.method_10982(Boolean.valueOf(true));
            case 'o' -> style.method_10978(Boolean.valueOf(true));
            case 'n' -> style.method_30938(Boolean.valueOf(true));
            case 'm' -> style.method_36140(Boolean.valueOf(true));
            case 'k' -> style.method_36141(Boolean.valueOf(true));
            case 'r' -> class_2583.field_24360;
            default -> style;
        };
    }

    private int getWrapWidth(LineObject line) {
        if (line.scale == 2.0f) {
            return 185;
        }
        if (line.scale == 1.5f) {
            return 250;
        }
        if (line.scale == 1.3f) {
            return 290;
        }
        if (line.scale == 1.1f) {
            return 340;
        }
        if (line.scale == 0.9f) {
            return 410;
        }
        return 370;
    }

    @AI
    private int getTotalContentHeight() {
        int totalHeight = 0;
        for (LineObject line : this.objectsToDisplay) {
            if (line.isImage()) {
                totalHeight += line.imageHeight + 16;
                continue;
            }
            if (line.isButton()) {
                totalHeight += 24;
                continue;
            }
            if (!line.isText()) continue;
            List wrapped = this.field_22793.method_1728((class_5348)line.text, this.getWrapWidth(line));
            Objects.requireNonNull(this.field_22793);
            int lineHeight = (int)((float)(9 + 2) * line.scale);
            totalHeight += wrapped.size() * lineHeight;
        }
        return totalHeight;
    }

    private void initializeTopAndBottom() {
        this.top = this.buttonList.method_46427() + 20;
        this.bottom = this.getDoneButtonHeight() - 16;
    }

    @AI
    private int getAccurateMaxScroll() {
        int visibleHeight = this.bottom - this.top;
        int totalHeight = this.getTotalContentHeight();
        return Math.max(0, totalHeight - visibleHeight);
    }

    public boolean centerAligned() {
        return true;
    }

    @Override
    protected void method_25426() {
        this.initializeCustomButtonListWidget();
        this.objectsToDisplay.clear();
        this.loadAndPrintText(SpeedrunnerMod.ofSpeedrunnerMod(this.getTextFile()));
        super.method_25426();
    }

    @Override
    @AI
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.isDraggingScrollbar && !this.isDraggingAnywhere) {
            this.scrollOffset += (this.targetScrollOffset - this.scrollOffset) * 0.2f;
            int maxScroll = this.getAccurateMaxScroll();
            this.scrollOffset = Math.max(0.0f, Math.min(this.scrollOffset, (float)maxScroll));
        } else {
            this.scrollOffset = this.targetScrollOffset;
        }
        super.method_25394(context, mouseX, mouseY, delta);
        this.initializeTopAndBottom();
        int scrollbarX = this.field_22789 - 10;
        int scrollbarWidth = 6;
        int scrollbarHeight = this.bottom - this.top;
        int contentHeight = this.getTotalContentHeight();
        double y = (float)this.top - this.scrollOffset;
        for (LineObject line : this.objectsToDisplay) {
            float scale = line.scale;
            if (line.isText()) {
                List wrapped = this.field_22793.method_1728((class_5348)line.text, this.getWrapWidth(line));
                Objects.requireNonNull(this.field_22793);
                int lineHeight = (int)((float)(9 + 2) * scale);
                for (class_5481 wrappedLine : wrapped) {
                    if (y + (double)lineHeight < (double)this.top) {
                        y += (double)lineHeight;
                        continue;
                    }
                    if (y >= (double)this.bottom) break;
                    int textWidth = this.field_22793.method_30880(wrappedLine);
                    double textX = (double)((float)this.field_22789 - (float)textWidth * scale) / 2.0;
                    context.method_51448().pushMatrix();
                    context.method_51448().translate(this.centerAligned() ? (float)textX : (float)this.field_22789 / 2.0f - 175.0f, (float)y);
                    context.method_51448().scale(scale, scale);
                    context.method_35720(this.field_22793, wrappedLine, 0, 0, -1);
                    context.method_51448().popMatrix();
                    y += (double)lineHeight;
                }
            }
            if (line.isImage()) {
                int scaledWidth = line.imageWidth;
                int scaledHeight = line.imageHeight;
                if (y + (double)scaledHeight < (double)this.top) {
                    y += (double)(scaledHeight + 16);
                    continue;
                }
                if (y >= (double)this.bottom) break;
                int visibleY = (int)Math.max(y, (double)this.top);
                int visibleHeight = (int)Math.min(y + (double)scaledHeight, (double)this.bottom) - visibleY;
                int imageYOffset = visibleY - (int)y;
                if (visibleHeight > 0) {
                    int x = (this.field_22789 - scaledWidth) / 2;
                    context.method_25290(class_10799.field_56883, line.imageId, x, visibleY, 0.0f, (float)imageYOffset, scaledWidth, visibleHeight, scaledWidth, scaledHeight);
                }
                y += (double)(scaledHeight + 16);
                continue;
            }
            if (!line.isButton()) continue;
            class_339 button = line.button();
            button.method_25358(this.getButtonsWidth());
            button.method_53533(20);
            button.method_46421(this.field_22789 / 2 - 75);
            button.method_46419((int)y);
            if (y + (double)button.method_25364() < (double)this.top || y >= (double)(this.bottom - 8)) {
                button.field_22764 = false;
                continue;
            }
            button.field_22764 = true;
            if (!this.method_25396().contains(button)) {
                this.method_37063((class_364)button);
            }
            button.field_22764 = true;
            if (!this.method_25396().contains(button)) {
                this.method_37063((class_364)button);
            }
            button.method_25394(context, mouseX, mouseY, delta);
            y += (double)(button.method_25364() + 4);
        }
        if (contentHeight > scrollbarHeight) {
            float scrollRatio = (float)scrollbarHeight / (float)contentHeight;
            int thumbHeight = Math.max((int)((float)scrollbarHeight * scrollRatio), 10);
            int maxScroll = this.getAccurateMaxScroll();
            float scrollPercent = this.scrollOffset / (float)maxScroll;
            int thumbY = this.top + (int)(scrollPercent * (float)(scrollbarHeight - thumbHeight));
            context.method_25294(scrollbarX, this.top, scrollbarX + scrollbarWidth, this.bottom, -14671840);
            boolean isHovered = mouseX >= scrollbarX && mouseX <= scrollbarX + scrollbarWidth && mouseY >= thumbY && mouseY <= thumbY + thumbHeight;
            int thumbColor = isHovered ? -1 : -6250336;
            context.method_25294(scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, thumbColor);
        }
    }

    @AI
    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (LineObject line : this.objectsToDisplay) {
            if (!line.isButton() || !line.button.field_22764 || !line.button.method_25405(mouseX, mouseY)) continue;
            class_339 class_3392 = line.button;
            if (class_3392 instanceof class_4185) {
                class_4185 buttonWidget = (class_4185)class_3392;
                buttonWidget.method_25306();
            } else {
                line.button.method_25348(mouseX, mouseY);
            }
            line.button.method_25354(class_310.method_1551().method_1483());
            return true;
        }
        if (button == 0) {
            this.isDraggingAnywhere = true;
            this.lastMouseY = (int)mouseY;
        }
        this.initializeTopAndBottom();
        int scrollbarX = this.field_22789 - 10;
        int scrollbarWidth = 6;
        int scrollbarHeight = this.bottom - this.top;
        int contentHeight = this.getTotalContentHeight();
        if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)this.top && mouseY <= (double)this.bottom && contentHeight > scrollbarHeight) {
            this.isDraggingScrollbar = true;
            this.lastMouseY = (int)mouseY;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @AI
    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isDraggingScrollbar = false;
        this.isDraggingAnywhere = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    @AI
    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.targetScrollOffset = (float)((double)this.targetScrollOffset - verticalAmount * 12.0);
        float maxScroll = this.getAccurateMaxScroll();
        this.targetScrollOffset = Math.max(0.0f, Math.min(this.targetScrollOffset - (float)(verticalAmount * 12.0), maxScroll));
        return true;
    }

    @AI
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.initializeTopAndBottom();
        int scrollbarHeight = this.bottom - this.top;
        int contentHeight = this.getTotalContentHeight();
        float maxScroll = this.getAccurateMaxScroll();
        if (this.isDraggingScrollbar) {
            int thumbHeight = Math.max((int)((float)scrollbarHeight * ((float)scrollbarHeight / (float)contentHeight)), 10);
            int trackHeight = scrollbarHeight - thumbHeight;
            float percent = (float)(mouseY - (double)this.top - (double)(thumbHeight / 2)) / (float)trackHeight;
            percent = Math.max(0.0f, Math.min(1.0f, percent));
            this.scrollOffset = this.targetScrollOffset = percent * maxScroll;
            return true;
        }
        if (this.isDraggingAnywhere) {
            int dy = (int)(mouseY - (double)this.lastMouseY);
            this.targetScrollOffset -= (float)dy;
            this.scrollOffset = this.targetScrollOffset = Math.max(0.0f, Math.min(this.targetScrollOffset, maxScroll));
            this.lastMouseY = (int)mouseY;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    @AI
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        float maxScroll = this.getAccurateMaxScroll();
        if (keyCode == 264) {
            this.targetScrollOffset = Math.min(this.targetScrollOffset + 12.0f, maxScroll);
            return true;
        }
        if (keyCode == 265) {
            this.targetScrollOffset = Math.max(this.targetScrollOffset - 12.0f, 0.0f);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    protected int columns() {
        return 2;
    }

    @Override
    protected boolean shouldRenderVersionText() {
        return false;
    }

    @Override
    public boolean isOptionsScreen() {
        return false;
    }

    @Override
    protected boolean shouldRenderTitleText() {
        return true;
    }

    @Override
    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    protected class_339 addButtonObject(class_339 button) {
        this.objectsToDisplay.add(new LineObject(null, 1.0f, null, 0, 0, button));
        return button;
    }

    protected String inTextsFolder(String fileName) {
        return "texts/" + fileName + ".txt";
    }

    protected int getButtonsWidth() {
        return 150;
    }

    protected abstract String getTextFile();

    @Environment(value=EnvType.CLIENT)
    @AI
    public record LineObject(class_2561 text, float scale, class_2960 imageId, int imageWidth, int imageHeight, class_339 button) {
        public boolean isImage() {
            return this.imageId != null;
        }

        public boolean isButton() {
            return this.button != null;
        }

        @NotNull
        public class_339 getButton() {
            return this.button;
        }

        public boolean isText() {
            return this.text != null && this.imageId == null && this.button == null;
        }
    }
}

