/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.client.screen.base.option;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.dillon.speedrunnermod.client.screen.base.AbstractModScreen;
import net.dillon.speedrunnermod.client.screen.feature.AbstractFeatureScreen;
import net.dillon.speedrunnermod.main.SpeedrunnerMod;
import net.dillon.speedrunnermod.main.SpeedrunnerModClient;
import net.dillon.speedrunnermod.option.OptionValue;
import net.dillon.speedrunnermod.util.AI;
import net.dillon.speedrunnermod.util.ModTexts;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class RestartRequiredScreen
extends AbstractModScreen {
    private static final List<OptionValue<?>> restartTrackedValues = new ArrayList();
    private static final List<Object> initialValues = new ArrayList<Object>();
    private static final Set<Object> processedObjects = new HashSet<Object>();

    public RestartRequiredScreen(class_437 parent) {
        super(parent, ModTexts.TITLE_RESTART_REQUIRED);
    }

    @Override
    protected void method_25426() {
        this.method_37063((class_364)class_4185.method_46430((class_2561)ModTexts.RESTART_NOW, buttonWidget -> {
            this.quitWorld();
            SpeedrunnerMod.info("Closing game! Re-launch to apply changes.");
            this.field_22787.method_1592();
        }).method_46434(this.getButtonsLeftSide(), this.getButtonsHeight(), 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)ModTexts.REVERT_CHANGES, buttonWidget -> {
            RestartRequiredScreen.revertChanges();
            SpeedrunnerMod.info("Changes reverted.");
            this.field_22787.method_1507(this.parent);
            class_437 patt0$temp = this.parent;
            if (patt0$temp instanceof AbstractFeatureScreen) {
                AbstractFeatureScreen abstractFeatureScreen = (AbstractFeatureScreen)patt0$temp;
                this.refreshFeatureScreen(abstractFeatureScreen.getPageNumber(), abstractFeatureScreen.getScreenCategory());
            }
        }).method_46434(this.getButtonsMiddle(), this.getButtonsHeight(), 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)ModTexts.NOT_NOW, buttonWidget -> this.method_25419()).method_46434(this.getButtonsRightSide(), this.getButtonsHeight(), 100, 20).method_46431());
    }

    @Override
    public void method_25419() {
        SpeedrunnerModClient.saveAllChanges();
        this.field_22787.method_1507(this.parent);
        class_437 class_4372 = this.parent;
        if (class_4372 instanceof AbstractFeatureScreen) {
            AbstractFeatureScreen abstractFeatureScreen = (AbstractFeatureScreen)class_4372;
            this.refreshFeatureScreen(abstractFeatureScreen.getPageNumber(), abstractFeatureScreen.getScreenCategory());
        }
        super.method_25419();
    }

    @Override
    public void renderCustomText(class_332 context) {
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"speedrunnermod.restart_required.line1"), this.field_22789 / 2, 110, -1);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"speedrunnermod.restart_required.line2"), this.field_22789 / 2, 130, -1);
    }

    @Override
    public String pageId() {
        return "biperwiqew";
    }

    @Override
    protected int getButtonsHeight() {
        return this.field_22790 / 6 + 126;
    }

    @Override
    protected int columns() {
        return 3;
    }

    @Override
    protected boolean shouldRenderVersionText() {
        return false;
    }

    @Override
    public boolean isOptionsScreen() {
        return false;
    }

    @Override
    protected boolean shouldRenderTitleText() {
        return true;
    }

    @AI
    public static void getCurrentOptions() {
        restartTrackedValues.clear();
        initialValues.clear();
        processedObjects.clear();
        RestartRequiredScreen.scanOptions(SpeedrunnerMod.options());
        RestartRequiredScreen.scanOptions(SpeedrunnerModClient.clientOptions());
    }

    @AI
    private static void scanOptions(Object optionsClass) {
        if (optionsClass == null) {
            SpeedrunnerMod.error("Options class is null");
            return;
        }
        if (processedObjects.contains(optionsClass)) {
            return;
        }
        processedObjects.add(optionsClass);
        for (Field field : optionsClass.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object value = field.get(optionsClass);
                if (value == null) continue;
                if (value instanceof OptionValue) {
                    OptionValue optionValue = (OptionValue)value;
                    if (!optionValue.requiresRestart()) continue;
                    restartTrackedValues.add(optionValue);
                    initialValues.add(optionValue.getCurrentValue());
                    continue;
                }
                if (value == null || value.getClass().isPrimitive() || !value.getClass().getName().startsWith("net.dillon.speedrunnermod")) continue;
                RestartRequiredScreen.scanOptions(value);
            }
            catch (IllegalAccessException e) {
                SpeedrunnerMod.debug("Failed to access field: " + field.getName() + " - " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @AI
    public static boolean needsRestart() {
        for (int i = 0; i < restartTrackedValues.size(); ++i) {
            OptionValue<?> option = restartTrackedValues.get(i);
            Object initialValue = initialValues.get(i);
            if (option.getCurrentValue().equals(initialValue)) continue;
            return true;
        }
        return false;
    }

    @AI
    private static void revertChanges() {
        for (int i = 0; i < restartTrackedValues.size(); ++i) {
            OptionValue<?> option = restartTrackedValues.get(i);
            option.set(initialValues.get(i));
            SpeedrunnerModClient.saveAllChanges();
            RestartRequiredScreen.getCurrentOptions();
        }
    }
}

