/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.client.screen.feature;

import java.util.List;
import net.dillon.speedrunnermod.client.screen.base.AbstractScrollableScreen;
import net.dillon.speedrunnermod.client.screen.base.MainScreen;
import net.dillon.speedrunnermod.client.screen.base.option.RestartRequiredScreen;
import net.dillon.speedrunnermod.client.screen.feature.BlocksAndItemsScreen;
import net.dillon.speedrunnermod.client.screen.feature.DoomModeScreen;
import net.dillon.speedrunnermod.client.screen.feature.FeaturesScreen;
import net.dillon.speedrunnermod.client.screen.feature.MiscellaneousScreen;
import net.dillon.speedrunnermod.client.screen.feature.OresAndWorldgenScreen;
import net.dillon.speedrunnermod.client.screen.feature.ScreenCategory;
import net.dillon.speedrunnermod.client.screen.feature.ScreenType;
import net.dillon.speedrunnermod.client.screen.feature.ToolsAndArmorScreen;
import net.dillon.speedrunnermod.client.screen.feature.blocksanditems.SpeedrunnerIngotsScreen;
import net.dillon.speedrunnermod.client.screen.feature.oresandworldgen.SpeedrunnersWastelandBiomeScreen;
import net.dillon.speedrunnermod.client.screen.feature.toolsandarmor.SpeedrunnerArmorScreen;
import net.dillon.speedrunnermod.client.screen.options.MainOptionsScreen;
import net.dillon.speedrunnermod.main.SpeedrunnerMod;
import net.dillon.speedrunnermod.main.SpeedrunnerModClient;
import net.dillon.speedrunnermod.util.AI;
import net.dillon.speedrunnermod.util.ModTexts;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractFeatureScreen
extends AbstractScrollableScreen {
    protected final class_437 parent;
    private class_437 category1Screen;
    private class_437 category2Screen;
    private class_437 category3Screen;
    private class_2561 category1Text;
    private class_2561 category2Text;
    private class_2561 category3Text;
    private boolean hasFourthCategory;
    @Nullable
    private class_437 category4Screen;
    @Nullable
    private class_2561 category4Text;
    private class_4185 nextButton;
    private class_4185 previousButton;
    protected static boolean restartRequired = false;

    public AbstractFeatureScreen(class_437 parent, class_2561 title) {
        super(parent, title);
        this.parent = parent;
    }

    public AbstractFeatureScreen(class_437 parent, class_2561 title, class_437 category1Screen, class_2561 category1Text, class_437 category2Screen, class_2561 category2Text, class_437 category3Screen, class_2561 category3Text, boolean hasFourthCategory, @Nullable class_437 category4Screen, @Nullable class_2561 category4Text) {
        super(parent, title);
        this.parent = parent;
        this.category1Screen = category1Screen;
        this.category2Screen = category2Screen;
        this.category3Screen = category3Screen;
        this.category1Text = category1Text;
        this.category2Text = category2Text;
        this.category3Text = category3Text;
        this.hasFourthCategory = hasFourthCategory;
        this.category4Screen = category4Screen;
        this.category4Text = category4Text;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (this.getScreenCategory() != ScreenCategory.SECRET_DOOM_MODE) {
            if (this.getScreenType() != ScreenType.LAST_PAGE && this.getScreenType() != ScreenType.END && this.getScreenType() != ScreenType.FIRST_TIME_PLAYING) {
                this.nextButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)ModTexts.NEXT_ARROW, button -> this.field_22787.method_1507(this.getNextScreen())).method_46434(this.getButtonsRightSide() + 100, this.getDoneButtonHeight(), 20, 20).method_46431());
            }
            if (this.getScreenType() != ScreenType.FIRST_PAGE && this.getScreenType() != ScreenType.FIRST_TIME_PLAYING) {
                this.previousButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)ModTexts.PREVIOUS, button -> this.field_22787.method_1507(this.getPreviousScreen())).method_46434(this.getButtonsLeftSide() + 30, this.getDoneButtonHeight(), 20, 20).method_46431());
            }
            if (this.getScreenType() == ScreenType.LAST_PAGE) {
                this.addButtonObject((class_339)class_4185.method_46430((class_2561)this.category1Text, button -> this.field_22787.method_1507(this.category1Screen)).method_46431());
                this.addButtonObject((class_339)class_4185.method_46430((class_2561)this.category2Text, button -> this.field_22787.method_1507(this.category2Screen)).method_46431());
                this.addButtonObject((class_339)class_4185.method_46430((class_2561)this.category3Text, button -> this.field_22787.method_1507(this.category3Screen)).method_46431());
                if (this.hasFourthCategory) {
                    this.addButtonObject((class_339)class_4185.method_46430((class_2561)this.category4Text, button -> this.field_22787.method_1507(this.category4Screen)).method_46431());
                }
            }
            if (this.getScreenType() == ScreenType.END) {
                this.addButtonObject((class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"speedrunnermod.menu.features.learn_more"), button -> this.openLink("https://modrinth.com/mod/speedrunner-mod", true)).method_46431());
                this.addButtonObject((class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"speedrunnermod.menu.features.blocks_and_items"), button -> this.field_22787.method_1507((class_437)new SpeedrunnerIngotsScreen(this.parent))).method_46431());
                this.addButtonObject((class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"speedrunnermod.menu.features.tools_and_armor"), button -> this.field_22787.method_1507((class_437)new SpeedrunnerArmorScreen(this.parent))).method_46431());
                this.addButtonObject((class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"speedrunnermod.menu.features.ores_and_worldgen"), button -> this.field_22787.method_1507((class_437)new SpeedrunnersWastelandBiomeScreen(this.parent))).method_46431());
            }
        }
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int leftSide = this.field_22789 / 2 - 155;
        int rightSide = leftSide + 160;
        int farRightSide = rightSide + 273;
        int height = this.field_22790 - 24;
        if (this.getScreenCategory() != ScreenCategory.SECRET_DOOM_MODE) {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)("\u00a7lPage:\u00a7r " + this.getPageNumber() + "/" + this.getMaxPages())), this.getScreenCategory() == ScreenCategory.FIRST_TIME_PLAYING ? this.field_22789 / 2 : farRightSide, height, -1);
        }
        if (this.getScreenCategory() == ScreenCategory.FIRST_TIME_PLAYING) {
            int middle = this.field_22789 / 2 - 128;
            int logoHeight = 10;
            context.method_25290(class_10799.field_56883, class_2960.method_60654((String)"speedrunnermod:textures/gui/speedrunner_mod.png"), middle, logoHeight, 0.0f, 0.0f, 258, 32, 258, 32);
        }
        this.renderTooltips(context, mouseX, mouseY);
    }

    @Override
    public void method_25419() {
        switch (this.getScreenCategory()) {
            case BLOCKS_AND_ITEMS: {
                this.field_22787.method_1507((class_437)new BlocksAndItemsScreen(this.parent));
                break;
            }
            case TOOLS_AND_ARMOR: {
                this.field_22787.method_1507((class_437)new ToolsAndArmorScreen(this.parent));
                break;
            }
            case ORES_AND_WORLDGEN: {
                this.field_22787.method_1507((class_437)new OresAndWorldgenScreen(this.parent));
                break;
            }
            case MISCELLANEOUS: {
                this.field_22787.method_1507((class_437)new MiscellaneousScreen(this.parent));
                break;
            }
            case DOOM_MODE: {
                this.field_22787.method_1507((class_437)new DoomModeScreen(this.parent));
                break;
            }
            case SECRET_DOOM_MODE: {
                this.field_22787.method_1507((class_437)new MainScreen(this.parent));
                break;
            }
            case FIRST_TIME_PLAYING: {
                SpeedrunnerMod.warn("Cannot close this screen!");
                break;
            }
            default: {
                this.field_22787.method_1507((class_437)new FeaturesScreen(this.parent));
            }
        }
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263 || keyCode == 65) {
            if (this.getPageNumber() != 1) {
                this.field_22787.method_1507(this.getPreviousScreen());
            }
            return true;
        }
        if (keyCode == 262 || keyCode == 68) {
            if (this.getScreenCategory() == ScreenCategory.FIRST_TIME_PLAYING && this.getPageNumber() >= 3) {
                SpeedrunnerMod.warn("Please choose an option!");
            } else if (this.getPageNumber() != this.getMaxPages()) {
                this.field_22787.method_1507(this.getNextScreen());
            }
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    protected boolean shouldRenderTitleText() {
        return this.getScreenCategory() != ScreenCategory.FIRST_TIME_PLAYING;
    }

    @Override
    protected String getTextFile() {
        switch (this.getScreenCategory()) {
            case BLOCKS_AND_ITEMS: {
                return this.inBlocksAndItemsFolder(this.linesKey());
            }
            case DOOM_MODE: {
                return this.inDoomModeFolder(this.linesKey());
            }
            case SECRET_DOOM_MODE: {
                return this.inSecretDoomModeFolder(this.linesKey());
            }
            case FIRST_TIME_PLAYING: {
                return this.inTextsFolder(this.linesKey());
            }
            case MISCELLANEOUS: {
                return this.inMiscellaneousFolder(this.linesKey());
            }
            case ORES_AND_WORLDGEN: {
                return this.inOresAndWorldgenFolder(this.linesKey());
            }
            case TOOLS_AND_ARMOR: {
                return this.inToolsAndArmor(this.linesKey());
            }
        }
        return this.linesKey();
    }

    @Override
    public String pageId() {
        return null;
    }

    protected int getMaxPages() {
        return this.getCategoryScreenClasses(this.getScreenCategory()).size();
    }

    private class_437 page(int pageNumber) {
        switch (this.getScreenCategory()) {
            case BLOCKS_AND_ITEMS: {
                return this.determineScreen(pageNumber, ScreenCategory.BLOCKS_AND_ITEMS);
            }
            case TOOLS_AND_ARMOR: {
                return this.determineScreen(pageNumber, ScreenCategory.TOOLS_AND_ARMOR);
            }
            case ORES_AND_WORLDGEN: {
                return this.determineScreen(pageNumber, ScreenCategory.ORES_AND_WORLDGEN);
            }
            case MISCELLANEOUS: {
                return this.determineScreen(pageNumber, ScreenCategory.MISCELLANEOUS);
            }
            case DOOM_MODE: {
                return this.determineScreen(pageNumber, ScreenCategory.DOOM_MODE);
            }
            case SECRET_DOOM_MODE: {
                return this.determineScreen(pageNumber, ScreenCategory.SECRET_DOOM_MODE);
            }
            case FIRST_TIME_PLAYING: {
                return this.determineScreen(pageNumber, ScreenCategory.FIRST_TIME_PLAYING);
            }
        }
        return new FeaturesScreen(this.parent);
    }

    private List<Class<? extends AbstractFeatureScreen>> getCategoryScreenClasses(ScreenCategory category) {
        switch (category) {
            case BLOCKS_AND_ITEMS: {
                return this.blocksAndItemsScreens();
            }
            case TOOLS_AND_ARMOR: {
                return this.toolsAndArmorScreens();
            }
            case ORES_AND_WORLDGEN: {
                return this.oresAndWorldGenFeatureScreens();
            }
            case MISCELLANEOUS: {
                return this.miscellaneousFeatureScreens();
            }
            case DOOM_MODE: {
                return this.doomModeFeatureScreens();
            }
            case SECRET_DOOM_MODE: {
                return this.secretDoomModeScreens();
            }
        }
        return this.firstTimePlayingScreens();
    }

    @AI
    private class_437 determineScreen(int pageNumber, ScreenCategory category) {
        List<Class<? extends AbstractFeatureScreen>> screenClasses = this.getCategoryScreenClasses(category);
        if (pageNumber > 0 && pageNumber <= screenClasses.size()) {
            try {
                Class<? extends AbstractFeatureScreen> screenClass = screenClasses.get(pageNumber - 1);
                return (class_437)screenClass.getDeclaredConstructor(class_437.class).newInstance(this.parent);
            }
            catch (Exception e) {
                SpeedrunnerMod.error("Failed to create screen: " + e.getMessage());
            }
        }
        return new FeaturesScreen(this.parent);
    }

    @AI
    public int getPageNumber() {
        List<Class<? extends AbstractFeatureScreen>> screenClasses = this.getCategoryScreenClasses(this.getScreenCategory());
        for (int i = 0; i < screenClasses.size(); ++i) {
            if (screenClasses.get(i) != ((Object)((Object)this)).getClass()) continue;
            return i + 1;
        }
        return 1;
    }

    @Nullable
    protected class_437 getNextScreen() {
        return this.page(this.getPageNumber() + 1);
    }

    @Nullable
    protected class_437 getPreviousScreen() {
        return this.page(this.getPageNumber() - 1);
    }

    @Override
    protected void renderTooltips(class_332 context, int mouseX, int mouseY) {
        if (this.getScreenCategory() != ScreenCategory.SECRET_DOOM_MODE) {
            if (this.getScreenType() == ScreenType.FIRST_PAGE || this.getScreenType() == ScreenType.DEFAULT) {
                if (this.nextButton.method_49606()) {
                    this.renderBasicTooltip(ModTexts.NEXT_ARROW_TOOLTIP, context, mouseX, mouseY);
                }
                if (this.getScreenType() == ScreenType.DEFAULT && this.previousButton.method_49606()) {
                    this.renderBasicTooltip(ModTexts.PREVIOUS_TOOLTIP, context, mouseX, mouseY);
                }
            } else if ((this.getScreenType() == ScreenType.LAST_PAGE || this.getScreenType() == ScreenType.END) && this.previousButton.method_49606()) {
                this.renderBasicTooltip(ModTexts.PREVIOUS_TOOLTIP, context, mouseX, mouseY);
            }
        }
    }

    protected void refreshNonRestartableFeature() {
        SpeedrunnerModClient.saveAllChanges();
        this.refreshFeatureScreen(this.getPageNumber(), this.getScreenCategory());
    }

    protected void refreshRestartableFeature() {
        RestartRequiredScreen.getCurrentOptions();
        this.field_22787.method_1507((class_437)new MainOptionsScreen((class_437)this));
    }

    protected String inBlocksAndItemsFolder(String fileName) {
        return "texts/features/blocksanditems/" + fileName + ".txt";
    }

    protected String inDoomModeFolder(String fileName) {
        return "texts/features/doommode/" + fileName + ".txt";
    }

    protected String inSecretDoomModeFolder(String fileName) {
        return "texts/features/secretdoommode/" + fileName + ".txt";
    }

    protected String inMiscellaneousFolder(String fileName) {
        return "texts/features/miscellaneous/" + fileName + ".txt";
    }

    protected String inOresAndWorldgenFolder(String fileName) {
        return "texts/features/oresandworldgen/" + fileName + ".txt";
    }

    protected String inToolsAndArmor(String fileName) {
        return "texts/features/toolsandarmor/" + fileName + ".txt";
    }

    @NotNull
    public abstract String linesKey();

    @NotNull
    public abstract ScreenCategory getScreenCategory();

    @NotNull
    protected abstract ScreenType getScreenType();
}

