/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.dillon.speedrunnermod.main.SpeedrunnerMod;
import net.dillon.speedrunnermod.option.ModOptions;
import net.dillon.speedrunnermod.server.ServerStorage;
import net.dillon.speedrunnermod.util.AI;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class SyncOptionsAuthorizeCommand {
    @AI
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"syncoptionsauthorize").requires(source -> !source.method_43737())).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"action", (ArgumentType)StringArgumentType.word()).executes(context -> {
            String player = StringArgumentType.getString((CommandContext)context, (String)"player");
            String action = StringArgumentType.getString((CommandContext)context, (String)"action");
            if (!ServerStorage.hasPendingSyncRequest(player)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("No pending sync request from " + player + ".")));
                return 0;
            }
            if (action.equalsIgnoreCase("accept")) {
                ModOptions clientOptions = ServerStorage.getPendingSyncRequest(player);
                SpeedrunnerMod.configHandler().match(clientOptions);
                for (class_3222 p : ((class_2168)context.getSource()).method_9211().method_3760().method_14571()) {
                    p.field_13987.method_52396((class_2561)class_2561.method_43469((String)"speedrunnermod.server_closed_sync_options", (Object[])new Object[]{player}));
                }
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"speedrunnermod.closing_server_sync_options", (Object[])new Object[]{player}));
                ((class_2168)context.getSource()).method_9211().method_3747(false);
            } else if (action.equalsIgnoreCase("deny")) {
                class_3222 requestingPlayer = ((class_2168)context.getSource()).method_9211().method_3760().method_14566(player);
                if (requestingPlayer != null) {
                    requestingPlayer.method_7353((class_2561)class_2561.method_43469((String)"speedrunnermod.sync_options_request_denied", (Object[])new Object[]{player}), false);
                }
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"speedrunnermod.denied_sync_options_request", (Object[])new Object[]{player}));
            }
            ServerStorage.removePendingSyncRequest(player);
            return 1;
        }))));
    }
}

