/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.data.loader;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.List;
import net.dillon.speedrunnermod.data.loader.LoaderMain;
import net.dillon.speedrunnermod.option.ModOptions;
import net.dillon.speedrunnermod.util.AI;

@AI
public class EntitySpawnsLoader {
    public static void modifyBiomesWithDefaultMonsters(JsonElement jsonElement) {
        HashMap<String, Integer[]> monsterSpawns = new HashMap<String, Integer[]>();
        monsterSpawns.put("minecraft:spider", LoaderMain.createSpawnSettings(ModOptions.isDoomMode() ? 75 : 100, ModOptions.isDoomMode() ? 1 : 4, ModOptions.isDoomMode() ? 5 : 4));
        monsterSpawns.put("minecraft:slime", LoaderMain.createSpawnSettings(ModOptions.isDoomMode() ? 50 : 100, 1, 4));
        monsterSpawns.put("minecraft:enderman", LoaderMain.createSpawnSettings(ModOptions.isDoomMode() ? 25 : 50, ModOptions.isDoomMode() ? 1 : 4, 4));
        monsterSpawns.put("minecraft:witch", LoaderMain.createSpawnSettings(ModOptions.isDoomMode() ? 50 : 5, 1, ModOptions.isDoomMode() ? 4 : 1));
        LoaderMain.modifyMonsterSpawns(jsonElement, monsterSpawns, false);
        HashMap<String, Integer[]> customOrNoChangedWeightMonsterSpawns = new HashMap<String, Integer[]>();
        monsterSpawns.put("minecraft:zombie", LoaderMain.createSpawnSettings(ModOptions.isDoomMode() ? 1 : 4, 4));
        monsterSpawns.put("minecraft:creeper", LoaderMain.createSpawnSettings(ModOptions.isDoomMode() ? 1 : 2, 4));
        LoaderMain.modifyMonsterSpawns(jsonElement, customOrNoChangedWeightMonsterSpawns, true);
    }

    public static void modifyBiomesWithFarmAnimals(JsonElement jsonElement) {
        HashMap<String, Integer[]> creatureSpawns = new HashMap<String, Integer[]>();
        creatureSpawns.put("minecraft:cow", LoaderMain.createSpawnSettings(16, 1, 4, 8, 4));
        creatureSpawns.put("minecraft:pig", LoaderMain.createSpawnSettings(12, 1, 4, 8, 4));
        creatureSpawns.put("minecraft:sheep", LoaderMain.createSpawnSettings(8, 1, 4, 8, 4));
        creatureSpawns.put("minecraft:chicken", LoaderMain.createSpawnSettings(8, 1, 4, 8, 4));
        LoaderMain.modifyCreatureSpawns(jsonElement, creatureSpawns, false);
    }

    public static void modifyWaterCreatureSpawns(JsonElement jsonElement) {
        HashMap<String, Integer[]> waterCreatureSpawns = new HashMap<String, Integer[]>();
        waterCreatureSpawns.put("minecraft:dolphin", LoaderMain.createSpawnSettings(15, 1, 1, 2, 1));
        waterCreatureSpawns.put("minecraft:tropical_fish", LoaderMain.createSpawnSettings(10, 1, 4, 8, 4));
        LoaderMain.modifyCreatureSpawns(jsonElement, waterCreatureSpawns, true);
    }

    public static List<String> biomesWithDefaultMonsters() {
        return List.of(EntitySpawnsLoader.biomeName("old_growth_pine_taiga"), EntitySpawnsLoader.biomeName("old_growth_spruce_taiga"), EntitySpawnsLoader.biomeName("windswept_hills"), EntitySpawnsLoader.biomeName("windswept_gravelly_hills"), EntitySpawnsLoader.biomeName("windswept_forest"), EntitySpawnsLoader.biomeName("savanna"), EntitySpawnsLoader.biomeName("savanna_plateau"), EntitySpawnsLoader.biomeName("windswept_savanna"), EntitySpawnsLoader.biomeName("badlands"), EntitySpawnsLoader.biomeName("eroded_badlands"), EntitySpawnsLoader.biomeName("wooded_badlands"), EntitySpawnsLoader.biomeName("frozen_ocean"), EntitySpawnsLoader.biomeName("deep_frozen_ocean"), EntitySpawnsLoader.biomeName("forest"), EntitySpawnsLoader.biomeName("flower_forest"), EntitySpawnsLoader.biomeName("birch_forest"), EntitySpawnsLoader.biomeName("old_growth_birch_forest"), EntitySpawnsLoader.biomeName("taiga"), EntitySpawnsLoader.biomeName("snowy_taiga"), EntitySpawnsLoader.biomeName("dark_forest"), EntitySpawnsLoader.biomeName("swamp"), EntitySpawnsLoader.biomeName("mangrove_swamp"), EntitySpawnsLoader.biomeName("river"), EntitySpawnsLoader.biomeName("frozen_river"), EntitySpawnsLoader.biomeName("beach"), EntitySpawnsLoader.biomeName("snowy_beach"), EntitySpawnsLoader.biomeName("stony_shore"), EntitySpawnsLoader.biomeName("meadow"), EntitySpawnsLoader.biomeName("frozen_peaks"), EntitySpawnsLoader.biomeName("jagged_peaks"), EntitySpawnsLoader.biomeName("stony_peaks"), EntitySpawnsLoader.biomeName("snowy_slopes"), EntitySpawnsLoader.biomeName("grove"), EntitySpawnsLoader.biomeName("lush_caves"));
    }

    public static List<String> biomesWithFarmAnimals() {
        return List.of(EntitySpawnsLoader.biomeName("old_growth_pine_taiga"), EntitySpawnsLoader.biomeName("old_growth_spruce_taiga"), EntitySpawnsLoader.biomeName("windswept_hills"), EntitySpawnsLoader.biomeName("windswept_gravelly_hills"), EntitySpawnsLoader.biomeName("windswept_forest"), EntitySpawnsLoader.biomeName("savanna"), EntitySpawnsLoader.biomeName("savanna_plateau"), EntitySpawnsLoader.biomeName("windswept_savanna"), EntitySpawnsLoader.biomeName("forest"), EntitySpawnsLoader.biomeName("flower_forest"), EntitySpawnsLoader.biomeName("birch_forest"), EntitySpawnsLoader.biomeName("old_growth_birch_forest"), EntitySpawnsLoader.biomeName("taiga"), EntitySpawnsLoader.biomeName("snowy_taiga"), EntitySpawnsLoader.biomeName("dark_forest"), EntitySpawnsLoader.biomeName("swamp"), EntitySpawnsLoader.biomeName("grove"));
    }

    private static String biomeName(String biomeName) {
        return "worldgen/biome/" + biomeName + ".json";
    }
}

