/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.data.loader;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.dillon.speedrunnermod.main.SpeedrunnerMod;
import net.dillon.speedrunnermod.option.ModOptions;
import net.dillon.speedrunnermod.util.AI;

@AI
public class LoaderMain {
    @AI
    protected static void modifyCreatureSpawns(JsonElement jsonElement, Map<String, Integer[]> creatureValues, boolean waterCreature) {
        JsonArray spawnersArray = jsonElement.getAsJsonObject().getAsJsonObject("spawners").getAsJsonArray(waterCreature ? "water_creature" : "creature");
        for (JsonElement spawnerElement : spawnersArray) {
            JsonObject spawner = spawnerElement.getAsJsonObject();
            String mobType = spawner.get("type").getAsString();
            if (!creatureValues.containsKey(mobType)) continue;
            Integer[] values = creatureValues.get(mobType);
            spawner.addProperty("weight", (Number)values[0]);
            if (SpeedrunnerMod.options().main.mobSpawningRate.getCurrentValue().equals((Object)ModOptions.MobSpawningRate.LOW)) {
                spawner.addProperty("minCount", (Number)values[1]);
                spawner.addProperty("maxCount", (Number)values[4]);
                continue;
            }
            if (SpeedrunnerMod.options().main.mobSpawningRate.getCurrentValue().equals((Object)ModOptions.MobSpawningRate.NORMAL)) {
                spawner.addProperty("minCount", (Number)values[2]);
                spawner.addProperty("maxCount", (Number)values[4]);
                continue;
            }
            if (!SpeedrunnerMod.options().main.mobSpawningRate.getCurrentValue().equals((Object)ModOptions.MobSpawningRate.HIGH)) continue;
            spawner.addProperty("minCount", (Number)values[2]);
            spawner.addProperty("maxCount", (Number)values[3]);
        }
    }

    @AI
    protected static void modifyMonsterSpawns(JsonElement jsonElement, Map<String, Integer[]> monsterValues, boolean customWeight) {
        JsonArray spawnersArray = jsonElement.getAsJsonObject().getAsJsonObject("spawners").getAsJsonArray("monster");
        for (JsonElement spawnerElement : spawnersArray) {
            JsonObject spawner = spawnerElement.getAsJsonObject();
            String mobType = spawner.get("type").getAsString();
            if (!monsterValues.containsKey(mobType)) continue;
            Integer[] values = monsterValues.get(mobType);
            if (!customWeight) {
                spawner.addProperty("weight", (Number)values[0]);
                spawner.addProperty("minCount", (Number)values[1]);
                spawner.addProperty("maxCount", (Number)values[2]);
                continue;
            }
            spawner.addProperty("minCount", (Number)values[0]);
            spawner.addProperty("maxCount", (Number)values[1]);
        }
        if (ModOptions.isDoomMode()) {
            JsonObject vindicator = new JsonObject();
            vindicator.addProperty("type", "minecraft:vindicator");
            vindicator.addProperty("maxCount", (Number)4);
            vindicator.addProperty("minCount", (Number)1);
            vindicator.addProperty("weight", (Number)100);
            spawnersArray.add((JsonElement)vindicator);
        }
    }

    protected static Integer[] createSpawnSettings(int weight, int minCountLow, int defaultMinCount, int maxCountHigh, int defaultMaxCount) {
        return new Integer[]{weight, minCountLow, defaultMinCount, maxCountHigh, defaultMaxCount};
    }

    protected static Integer[] createSpawnSettings(int weight, int minCount, int maxCount) {
        return new Integer[]{weight, minCount, maxCount};
    }

    protected static Integer[] createSpawnSettings(int minCount, int maxCount) {
        return new Integer[]{0, minCount, maxCount};
    }
}

