/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.speedrunnermod.data.loader;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.dillon.speedrunnermod.option.ModOptions;
import net.dillon.speedrunnermod.util.AI;

@AI
public class PlacedFeaturesLoader {
    public static void modifyMonsterRoom(JsonElement jsonElement) {
        JsonArray placement = jsonElement.getAsJsonObject().getAsJsonArray("placement");
        for (JsonElement element : placement) {
            JsonObject placementObj = element.getAsJsonObject();
            if (!placementObj.has("type") || !placementObj.get("type").getAsString().equals("minecraft:count")) continue;
            placementObj.addProperty("count", (Number)(ModOptions.isSsrEverywhere() || ModOptions.isSsrVeryCommonCommon() || ModOptions.isSsrNormal() ? 16 : 8));
            break;
        }
    }

    public static void modifyOreDiamond(String fileName, String oreDiamond, JsonElement jsonElement) {
        JsonArray placement = jsonElement.getAsJsonObject().getAsJsonArray("placement");
        for (JsonElement element : placement) {
            JsonObject placementObj = element.getAsJsonObject();
            if (!placementObj.has("type") || !placementObj.get("type").getAsString().equals("minecraft:count")) continue;
            placementObj.addProperty("count", (Number)(fileName.equals(oreDiamond) ? 8 : 9));
            break;
        }
    }

    public static void modifyOreDiamondLarge(JsonElement jsonElement) {
        JsonArray placement = jsonElement.getAsJsonObject().getAsJsonArray("placement");
        for (JsonElement element : placement) {
            JsonObject placementObj = element.getAsJsonObject();
            if (!placementObj.has("type") || !placementObj.get("type").getAsString().equals("minecraft:rarity_filter")) continue;
            placementObj.addProperty("type", "minecraft:count");
            int chance = placementObj.get("chance").getAsInt();
            placementObj.remove("chance");
            placementObj.addProperty("count", (Number)chance);
            placementObj.addProperty("count", (Number)5);
            break;
        }
    }

    public static void modifyOreLapis(String fileName, String oreLapis, JsonElement jsonElement) {
        JsonArray placement = jsonElement.getAsJsonObject().getAsJsonArray("placement");
        for (JsonElement element : placement) {
            JsonObject placementObj = element.getAsJsonObject();
            if (!placementObj.has("type") || !placementObj.get("type").getAsString().equals("minecraft:count")) continue;
            placementObj.addProperty("count", (Number)(fileName.equals(oreLapis) ? 3 : 4));
            break;
        }
    }

    public static void modifyTreePlains(JsonElement jsonElement) {
        JsonArray placement = jsonElement.getAsJsonObject().getAsJsonArray("placement");
        for (JsonElement element : placement) {
            JsonObject placementObj = element.getAsJsonObject();
            if (!placementObj.has("type") || !placementObj.get("type").getAsString().equals("minecraft:count")) continue;
            JsonObject countObject = placementObj.getAsJsonObject("count");
            JsonArray distributionArray = countObject.getAsJsonArray("distribution");
            JsonObject firstElement = distributionArray.get(0).getAsJsonObject();
            firstElement.addProperty("data", (Number)1);
            break;
        }
    }
}

